/*
 * Decompiled with CFR 0.152.
 */
package adams.data.fit;

import adams.core.Utils;
import adams.data.fit.LinearFunction;

public class Polynomial
extends LinearFunction {
    private static final long serialVersionUID = 8671881135961725212L;

    @Override
    public String globalInfo() {
        return "Polynomial function of the form:\nf(x) = a0 + a1*x + a2*x^2 + ... + aN*x^N";
    }

    @Override
    public double[] calcFunctionValues(double x, int num) {
        double[] result = new double[num];
        result[0] = 1.0;
        for (int i = 1; i < num; ++i) {
            result[i] = result[i - 1] * x;
        }
        this.getDebugging().println("x=" + x + " -> " + Utils.arrayToString(result));
        return result;
    }

    @Override
    public double calcY(double x, double[] a) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i] * Math.pow(x, i);
        }
        this.getDebugging().println("x=" + x + " -> y=" + result);
        return result;
    }
}

