/*
 * Decompiled with CFR 0.152.
 */
package adams.data.fit;

import adams.core.Utils;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.data.fit.Fit;
import adams.data.fit.LinearLeastSquares;
import adams.env.Environment;

public class RunFit
implements OptionHandler {
    protected OptionManager m_OptionManager;
    protected double[] m_X;
    protected double[] m_Y;
    protected double[] m_SigmaX;
    protected double[] m_SigmaY;
    protected int m_NumPoints;
    protected double[] m_InitialGuesses;
    protected Fit m_Fit;

    public RunFit() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
    }

    protected void initialize() {
        this.m_X = new double[0];
        this.m_Y = new double[0];
        this.m_SigmaX = null;
        this.m_SigmaY = null;
    }

    protected OptionManager newOptionManager() {
        return new OptionManager(this);
    }

    @Override
    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
        this.m_OptionManager.add("x", "x", "1,2,3,4,5,6,7,8,9,10");
        this.m_OptionManager.add("y", "y", "1,4,9,16,25,36,49,64,81,100");
        this.m_OptionManager.add("sigma-x", "sigmaX", "");
        this.m_OptionManager.add("sigma-y", "sigmaY", "");
        this.m_OptionManager.add("num-points", "numPoints", 3);
        this.m_OptionManager.add("guesses", "initialGuesses", "");
        this.m_OptionManager.add("fit", "fit", new LinearLeastSquares());
    }

    @Override
    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    @Override
    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    @Override
    public void destroy() {
        this.cleanUpOptions();
    }

    protected double[] str2doubleArray(String s) {
        double[] result = null;
        if (s != null && s.length() > 0) {
            String[] parts = s.replaceAll(" ", "").split(",");
            result = new double[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Double.parseDouble(parts[i]);
            }
        }
        return result;
    }

    protected String doubleArray2str(double[] d) {
        String result = "";
        if (d != null) {
            for (int i = 0; i < d.length; ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + d[i];
            }
        }
        return result;
    }

    public void setX(String value) {
        if (value.length() != 0) {
            this.m_X = this.str2doubleArray(value);
        } else {
            System.err.println("x values cannot be empty!");
        }
    }

    public String getX() {
        return this.doubleArray2str(this.m_X);
    }

    public String xTipText() {
        return "The x values (comma-separated list).";
    }

    public void setY(String value) {
        if (value.length() != 0) {
            this.m_Y = this.str2doubleArray(value);
        } else {
            System.err.println("y values cannot be empty!");
        }
    }

    public String getY() {
        return this.doubleArray2str(this.m_Y);
    }

    public String yTipText() {
        return "The y values (comma-separated list).";
    }

    public void setSigmaX(String value) {
        this.m_SigmaX = this.str2doubleArray(value);
    }

    public String getSigmaX() {
        return this.doubleArray2str(this.m_SigmaX);
    }

    public String sigmaXTipText() {
        return "The sigma-x values (comma-separated list).";
    }

    public void setSigmaY(String value) {
        this.m_SigmaY = this.str2doubleArray(value);
    }

    public String getSigmaY() {
        return this.doubleArray2str(this.m_SigmaY);
    }

    public String sigmaYTipText() {
        return "The sigma-y values (comma-separated list).";
    }

    public void setNumPoints(int value) {
        this.m_NumPoints = value;
    }

    public int getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The number of points, ie, basis functions, to use.";
    }

    public void setInitialGuesses(String value) {
        this.m_InitialGuesses = this.str2doubleArray(value);
    }

    public String getInitialGuesses() {
        return this.doubleArray2str(this.m_InitialGuesses);
    }

    public String initialGuessesTipText() {
        return "The values of the initial guesses (comma-separated list).";
    }

    public void setFit(Fit value) {
        this.m_Fit = value;
    }

    public Fit getFit() {
        return this.m_Fit;
    }

    public String fitTipText() {
        return "The fitting algorithm to use.";
    }

    public void run() throws Exception {
        double[] parameters;
        double[] initial = null;
        if (this.m_InitialGuesses != null) {
            initial = (double[])this.m_InitialGuesses.clone();
        }
        if (initial == null) {
            parameters = new double[this.m_NumPoints];
        } else {
            if (initial.length != this.m_NumPoints) {
                throw new IllegalArgumentException("Number of initial guesses differ from number of points!");
            }
            parameters = (double[])initial.clone();
        }
        if (this.m_X.length != this.m_Y.length) {
            throw new IllegalArgumentException("x and y have different length!");
        }
        if (this.m_SigmaX != null && this.m_SigmaX.length != this.m_X.length) {
            throw new IllegalArgumentException("sigma-x and x have different length!");
        }
        if (this.m_SigmaY != null && this.m_SigmaY.length != this.m_X.length) {
            throw new IllegalArgumentException("sigma-x and x have different length!");
        }
        if (this.m_InitialGuesses == null && this.m_Fit.canGuess()) {
            initial = this.m_Fit.guess(this.m_X, this.m_Y);
            parameters = (double[])initial.clone();
        }
        boolean success = this.m_Fit.fitClean(parameters, this.m_X, this.m_Y, this.m_SigmaX, this.m_SigmaY);
        System.out.println(this.m_Fit.getDescription());
        System.out.println(this.m_Fit.getDescription().replaceAll(".", "="));
        System.out.println();
        System.out.println("Algorithm..: " + OptionUtils.getCommandLine(this.m_Fit));
        System.out.println("x..........: " + this.getX());
        System.out.println("y..........: " + this.getY());
        System.out.println("sigma-x....: " + (this.getSigmaX().length() == 0 ? "-none-" : this.getSigmaX()));
        System.out.println("sigma-y....: " + (this.getSigmaY().length() == 0 ? "-none-" : this.getSigmaY()));
        System.out.println("# of points: " + this.getNumPoints());
        System.out.println("guesses....: " + (initial == null ? "-none-" : Utils.arrayToString(initial)));
        System.out.println();
        if (!success) {
            System.out.println("Fitting wasn't successful!");
            System.out.println();
        }
        System.out.println("Coefficients");
        for (int i = 0; i < this.m_NumPoints; ++i) {
            System.out.println(parameters[i]);
        }
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        RunFit runFit = new RunFit();
        try {
            if (OptionUtils.helpRequested(args)) {
                System.out.println("Help requested...\n");
                System.out.println(OptionUtils.list(runFit));
            } else {
                ArrayConsumer.setOptions(runFit, args);
                runFit.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

