/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.annotation.MixedCopyright;
import adams.gui.core.BaseTable;
import adams.gui.core.SearchableTable;
import adams.gui.core.SearchableTableModel;
import adams.gui.core.SortableAndSearchableWrapperTableModel;
import adams.gui.core.SortableTable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

@MixedCopyright
public class SortableAndSearchableTable
extends BaseTable
implements SortableTable,
SearchableTable {
    private static final long serialVersionUID = -3176811618121454828L;
    public static final String KEY_SORTCOL = "sort col";
    public static final String KEY_SORTORDER = "sort order";
    public static final String KEY_SEARCHSTRING = "search string";
    public static final String KEY_SEARCHREGEXP = "search reg exp";
    protected SortableAndSearchableWrapperTableModel m_Model;
    protected boolean m_UseOptimalColumnWidths;
    protected boolean m_SortNewTableModel;

    public SortableAndSearchableTable() {
    }

    public SortableAndSearchableTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public SortableAndSearchableTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public SortableAndSearchableTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public SortableAndSearchableTable(TableModel dm) {
        super(dm);
    }

    public SortableAndSearchableTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public SortableAndSearchableTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    protected boolean initialUseOptimalColumnWidths() {
        return false;
    }

    public void setUseOptimalColumnWidhts(boolean value) {
        this.m_UseOptimalColumnWidths = value;
        if (this.m_UseOptimalColumnWidths) {
            this.setAutoResizeMode(0);
            this.setOptimalColumnWidth();
        }
    }

    public boolean getUseOptimalColumnWidths() {
        return this.m_UseOptimalColumnWidths;
    }

    protected boolean initialSortNewTableModel() {
        return false;
    }

    public void setSortNewTableModel(boolean value) {
        this.m_SortNewTableModel = value;
        if (this.m_SortNewTableModel) {
            this.sort(0);
        }
    }

    public boolean getSortNewTableModel() {
        return this.m_SortNewTableModel;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_SortNewTableModel = this.initialSortNewTableModel();
        this.m_Model.addMouseListenerToHeader(this);
        if (this.getSortNewTableModel()) {
            this.sort(0);
        }
        this.m_UseOptimalColumnWidths = this.initialUseOptimalColumnWidths();
        if (this.getUseOptimalColumnWidths()) {
            this.setAutoResizeMode(0);
            this.setOptimalColumnWidth();
        }
    }

    protected Class getTableModelClass() {
        return TableModel.class;
    }

    protected Hashtable<String, Object> backupModelSettings(TableModel model) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(KEY_SORTCOL, this.m_Model.getSortColumn());
        result.put(KEY_SORTORDER, this.m_Model.isAscending());
        if (model instanceof SearchableTableModel) {
            if (((SearchableTableModel)model).getSeachString() != null) {
                result.put(KEY_SEARCHSTRING, ((SearchableTableModel)model).getSeachString());
            }
            result.put(KEY_SEARCHREGEXP, ((SearchableTableModel)model).isRegExpSearch());
        }
        return result;
    }

    protected void restoreModelSettings(TableModel model, Hashtable<String, Object> settings) {
        int sortCol = 0;
        boolean asc = true;
        String search = null;
        boolean regexp = false;
        if (settings != null) {
            sortCol = (Integer)settings.get(KEY_SORTCOL);
            asc = (Boolean)settings.get(KEY_SORTORDER);
            if (model instanceof SearchableTableModel) {
                search = (String)settings.get(KEY_SEARCHSTRING);
                regexp = (Boolean)settings.get(KEY_SEARCHREGEXP);
            }
        }
        if (this.getSortNewTableModel()) {
            this.m_Model.sort(sortCol, asc);
        }
        if (model instanceof SearchableTableModel) {
            ((SearchableTableModel)model).search(search, regexp);
        }
        if (this.getUseOptimalColumnWidths()) {
            this.setOptimalColumnWidth();
        }
    }

    @Override
    public synchronized void setModel(TableModel model) {
        Hashtable<String, Object> settings;
        if (!this.getTableModelClass().isInstance(model)) {
            model = this.createDefaultDataModel();
        }
        if (this.m_Model != null) {
            settings = this.backupModelSettings(this.m_Model);
            this.getTableHeader().removeMouseListener(this.m_Model.getHeaderMouseListener());
        } else {
            settings = null;
        }
        this.m_Model = new SortableAndSearchableWrapperTableModel(model);
        super.setModel(this.m_Model);
        this.m_Model.addMouseListenerToHeader(this);
        this.restoreModelSettings(this.m_Model, settings);
    }

    @Override
    public synchronized void setUnsortedModel(TableModel value) {
        this.m_Model.setUnsortedModel(value);
    }

    public synchronized void setUnsortedModel(TableModel value, boolean restoreSorting) {
        this.m_Model.setUnsortedModel(value, restoreSorting);
    }

    @Override
    public synchronized TableModel getUnsortedModel() {
        return this.m_Model.getUnsortedModel();
    }

    @Override
    public synchronized int getActualRow(int visibleRow) {
        return this.m_Model.getActualRow(visibleRow);
    }

    public synchronized int getDisplayRow(int internalRow) {
        return this.m_Model.getDisplayRow(internalRow);
    }

    @Override
    public synchronized boolean isSorted() {
        return this.m_Model.isSorted();
    }

    @Override
    public synchronized int getSortColumn() {
        return this.m_Model.getSortColumn();
    }

    @Override
    public synchronized boolean isAscending() {
        return this.m_Model.isAscending();
    }

    @Override
    public synchronized void sort(int columnIndex) {
        if (this.m_Model != null) {
            this.m_Model.sort(columnIndex);
        }
    }

    @Override
    public synchronized void sort(int columnIndex, boolean ascending) {
        if (this.m_Model != null) {
            this.m_Model.sort(columnIndex, ascending);
        }
    }

    @Override
    public synchronized int getActualRowCount() {
        return this.m_Model.getActualRowCount();
    }

    @Override
    public synchronized void search(String searchString, boolean regexp) {
        int i;
        int[] selected = this.getSelectedRows();
        for (i = 0; i < selected.length; ++i) {
            selected[i] = this.getActualRow(selected[i]);
        }
        this.m_Model.search(searchString, regexp);
        this.clearSelection();
        for (i = 0; i < selected.length; ++i) {
            int index = this.getDisplayRow(selected[i]);
            if (index == -1) continue;
            this.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    @Override
    public synchronized String getSeachString() {
        return this.m_Model.getSeachString();
    }

    @Override
    public synchronized boolean isRegExpSearch() {
        return this.m_Model.isRegExpSearch();
    }
}

