/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.option.AbstractOptionConsumer;
import adams.core.option.FileBasedConsumer;
import adams.core.option.NestedConsumer;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.AbstractApprovalDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImportDialog
extends AbstractApprovalDialog {
    private static final long serialVersionUID = 201725070566669323L;
    protected FileChooserPanel m_PanelFile;
    protected GenericObjectEditorPanel m_PanelGOE;

    public ImportDialog(Dialog owner) {
        super(owner);
    }

    public ImportDialog(Dialog owner, Dialog.ModalityType modality) {
        super(owner, modality);
    }

    public ImportDialog(Frame owner) {
        super(owner);
    }

    public ImportDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setTitle("Import flow");
        ParameterPanel params = new ParameterPanel();
        this.getContentPane().add((Component)params, "Center");
        this.m_PanelFile = new FileChooserPanel();
        this.m_PanelFile.setPromptOverwriteFile(true);
        params.addParameter("_File", (Component)this.m_PanelFile);
        this.m_PanelGOE = new GenericObjectEditorPanel(AbstractOptionConsumer.class, new NestedConsumer(), true);
        this.m_PanelGOE.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImportDialog.this.updateFileChooser();
            }
        });
        params.addParameter("For_mat", (Component)this.m_PanelGOE);
        this.pack();
    }

    protected void updateFileChooser() {
        this.m_PanelFile.setDefaultExtension(null);
        this.m_PanelFile.removeChoosableFileFilters();
        this.m_PanelFile.setAcceptAllFileFilterUsed(true);
        this.m_PanelFile.setAutoAppendExtension(false);
        if (this.m_PanelGOE.getCurrent() instanceof FileBasedConsumer) {
            FileBasedConsumer producer = (FileBasedConsumer)this.m_PanelGOE.getCurrent();
            ExtensionFileFilter filter = new ExtensionFileFilter(producer.getFileFormat(), producer.getFileExtensions());
            this.m_PanelFile.setDefaultExtension(producer.getDefaultFileExtension());
            this.m_PanelFile.setAutoAppendExtension(true);
            this.m_PanelFile.addChoosableFileFilter(filter);
            this.m_PanelFile.setFileFilter(filter);
        }
    }

    public void setConsumer(AbstractOptionConsumer value) {
        if (value == null) {
            value = new NestedConsumer();
        }
        this.m_PanelGOE.setCurrent(value);
    }

    public AbstractOptionConsumer getConsumer() {
        return (AbstractOptionConsumer)this.m_PanelGOE.getCurrent();
    }

    public void setFile(File value) {
        this.m_PanelFile.setCurrent(value);
    }

    public File getFile() {
        return (File)this.m_PanelFile.getCurrent();
    }
}

