/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.ClassLister;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseListWithButtons;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.goe.Favorites;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FavoritesManagementPanel
extends BasePanel
implements MenuBarProvider {
    private static final long serialVersionUID = 7641450241106552195L;
    public static final String SEPARATOR = "/";
    protected Favorites m_Favorites;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemSave;
    protected JMenuItem m_MenuItemRevert;
    protected JMenuItem m_MenuItemClose;
    protected BaseListWithButtons m_PanelSuperclasses;
    protected JButton m_ButtonSuperclassAdd;
    protected JButton m_ButtonSuperclassRemove;
    protected JButton m_ButtonSuperclassRemoveAll;
    protected BaseListWithButtons m_PanelFavorites;
    protected JButton m_ButtonFavoriteAdd;
    protected JButton m_ButtonFavoriteEdit;
    protected JButton m_ButtonFavoriteRename;
    protected JButton m_ButtonFavoriteRemove;
    protected JButton m_ButtonFavoriteRemoveAll;
    protected SuperclassListModel m_ListModelSuperclass;
    protected FavoritesListModel m_ListModelFavorites;
    protected GenericObjectEditorDialog m_GOEDialog;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Favorites = Favorites.getSingleton().getClone();
        this.m_Favorites.setAutoSave(false);
        this.m_ListModelSuperclass = new SuperclassListModel(this.m_Favorites);
        this.m_ListModelFavorites = new FavoritesListModel(this.m_Favorites);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new GridLayout(1, 2));
        this.m_PanelSuperclasses = new BaseListWithButtons();
        this.m_PanelSuperclasses.setBorder(BorderFactory.createTitledBorder("Superclass"));
        this.m_PanelSuperclasses.setModel(this.m_ListModelSuperclass);
        this.m_PanelSuperclasses.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FavoritesManagementPanel.this.m_PanelSuperclasses.getSelectedIndices().length == 1) {
                    FavoritesManagementPanel.this.m_ListModelFavorites.setSuperclass((String)FavoritesManagementPanel.this.m_PanelSuperclasses.getSelectedValue());
                }
                FavoritesManagementPanel.this.update();
            }
        });
        this.add(this.m_PanelSuperclasses);
        this.m_ButtonSuperclassAdd = new JButton("Add...");
        this.m_ButtonSuperclassAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesManagementPanel.this.addSuperclass();
                FavoritesManagementPanel.this.update();
            }
        });
        this.m_PanelSuperclasses.addToButtonsPanel(this.m_ButtonSuperclassAdd);
        this.m_ButtonSuperclassRemove = new JButton("Remove");
        this.m_ButtonSuperclassRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] classes = FavoritesManagementPanel.this.m_PanelSuperclasses.getSelectedValues();
                for (int i = 0; i < classes.length; ++i) {
                    FavoritesManagementPanel.this.m_Favorites.removeFavorites(classes[i].toString());
                }
                FavoritesManagementPanel.this.m_ListModelSuperclass.update();
                FavoritesManagementPanel.this.m_ListModelFavorites.update();
                FavoritesManagementPanel.this.update();
            }
        });
        this.m_PanelSuperclasses.addToButtonsPanel(this.m_ButtonSuperclassRemove);
        this.m_ButtonSuperclassRemoveAll = new JButton("Remove all");
        this.m_ButtonSuperclassRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesManagementPanel.this.m_Favorites.clear();
                FavoritesManagementPanel.this.m_ListModelFavorites.setSuperclass((Class)null);
                FavoritesManagementPanel.this.m_ListModelSuperclass.update();
                FavoritesManagementPanel.this.update();
            }
        });
        this.m_PanelSuperclasses.addToButtonsPanel(this.m_ButtonSuperclassRemoveAll);
        this.m_PanelFavorites = new BaseListWithButtons();
        this.m_PanelFavorites.setBorder(BorderFactory.createTitledBorder("Favorites"));
        this.m_PanelFavorites.setModel(this.m_ListModelFavorites);
        this.m_PanelFavorites.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FavoritesManagementPanel.this.update();
            }
        });
        this.add(this.m_PanelFavorites);
        this.m_ButtonFavoriteAdd = new JButton("Add...");
        this.m_ButtonFavoriteAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesManagementPanel.this.addFavorite(FavoritesManagementPanel.this.m_ListModelFavorites.getSuperclass());
                FavoritesManagementPanel.this.update();
            }
        });
        this.m_PanelFavorites.addToButtonsPanel(this.m_ButtonFavoriteAdd);
        this.m_ButtonFavoriteEdit = new JButton("Edit...");
        this.m_ButtonFavoriteEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesManagementPanel.this.editFavorite(FavoritesManagementPanel.this.m_ListModelFavorites.getSuperclass(), (String)FavoritesManagementPanel.this.m_PanelFavorites.getSelectedValue());
                FavoritesManagementPanel.this.update();
            }
        });
        this.m_PanelFavorites.addToButtonsPanel(this.m_ButtonFavoriteEdit);
        this.m_PanelFavorites.setDoubleClickButton(this.m_ButtonFavoriteEdit);
        this.m_ButtonFavoriteRename = new JButton("Rename...");
        this.m_ButtonFavoriteRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesManagementPanel.this.renameFavorite(FavoritesManagementPanel.this.m_ListModelFavorites.getSuperclass(), (String)FavoritesManagementPanel.this.m_PanelFavorites.getSelectedValue());
                FavoritesManagementPanel.this.update();
            }
        });
        this.m_PanelFavorites.addToButtonsPanel(this.m_ButtonFavoriteRename);
        this.m_ButtonFavoriteRemove = new JButton("Remove");
        this.m_ButtonFavoriteRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FavoritesManagementPanel.this.m_ListModelFavorites.getSuperclass() == null) {
                    return;
                }
                Object[] entries = FavoritesManagementPanel.this.m_PanelFavorites.getSelectedValues();
                for (int i = 0; i < entries.length; ++i) {
                    FavoritesManagementPanel.this.m_Favorites.removeFavorite(FavoritesManagementPanel.this.m_ListModelFavorites.getSuperclass(), entries[i].toString());
                }
                FavoritesManagementPanel.this.m_ListModelSuperclass.update();
                FavoritesManagementPanel.this.m_ListModelFavorites.update();
                FavoritesManagementPanel.this.update();
            }
        });
        this.m_PanelFavorites.addToButtonsPanel(this.m_ButtonFavoriteRemove);
        this.m_ButtonFavoriteRemoveAll = new JButton("Remove all");
        this.m_ButtonFavoriteRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FavoritesManagementPanel.this.m_ListModelFavorites.getSuperclass() == null) {
                    return;
                }
                FavoritesManagementPanel.this.m_Favorites.removeFavorites(FavoritesManagementPanel.this.m_ListModelFavorites.getSuperclass());
                FavoritesManagementPanel.this.m_ListModelSuperclass.update();
                FavoritesManagementPanel.this.m_ListModelFavorites.update();
                FavoritesManagementPanel.this.update();
            }
        });
        this.m_PanelFavorites.addToButtonsPanel(this.m_ButtonFavoriteRemoveAll);
        this.update();
    }

    protected GenericObjectEditorDialog getGOEEditor() {
        if (this.m_GOEDialog == null) {
            this.m_GOEDialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog()) : new GenericObjectEditorDialog(this.getParentFrame());
            this.m_GOEDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            this.m_GOEDialog.getGOEEditor().setCanChangeClassInDialog(true);
        }
        return this.m_GOEDialog;
    }

    protected void addSuperclass() {
        BaseDialog dialog = this.getParentFrame() != null ? new BaseDialog(this.getParentFrame(), true) : new BaseDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setTitle("Add superclass");
        dialog.getContentPane().setLayout(new BorderLayout());
        Vector<String> superclasses = new Vector<String>(ClassLister.getSingleton().getClasses().keySetAll());
        Collections.sort(superclasses);
        BasePanel panelBox = new BasePanel(new FlowLayout(0));
        final JComboBox<String> combobox = new JComboBox<String>(superclasses);
        JLabel label = new JLabel("Superclass");
        label.setDisplayedMnemonic('S');
        label.setLabelFor(combobox);
        panelBox.add(label);
        panelBox.add(combobox);
        dialog.getContentPane().add((Component)panelBox, "Center");
        final BaseDialog dialogF = dialog;
        BasePanel panel = new BasePanel(new FlowLayout(2));
        dialog.getContentPane().add((Component)panel, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Class<?> cls = Class.forName((String)combobox.getSelectedItem());
                    FavoritesManagementPanel.this.m_ListModelFavorites.setSuperclass(cls);
                    FavoritesManagementPanel.this.addFavorite(cls);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    GUIHelper.showErrorMessage(FavoritesManagementPanel.this, "Error encountered:\n" + ex.toString());
                }
                dialogF.setVisible(false);
            }
        });
        panel.add(buttonOK);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.setMnemonic('C');
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogF.setVisible(false);
            }
        });
        panel.add(buttonCancel);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    protected void addFavorite(Class cls) {
        String[] classes = ClassLister.getSingleton().getClassnames(cls);
        if (classes.length == 0) {
            GUIHelper.showErrorMessage(this, "No classes available for superclass " + cls.getName());
            return;
        }
        Object obj = null;
        try {
            Class<?> subcls = Class.forName(classes[0]);
            obj = subcls.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            GUIHelper.showErrorMessage(this, "Failed to instantiate class " + classes[0] + ":\n" + e.toString());
            return;
        }
        GenericObjectEditorDialog dialog = this.getGOEEditor();
        dialog.setTitle("Add Favorite (" + cls.getName() + ")");
        dialog.getGOEEditor().setClassType(cls);
        dialog.getGOEEditor().setValue(obj);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        String name = JOptionPane.showInputDialog("Please input name for favorite:");
        if (name == null) {
            return;
        }
        this.m_Favorites.addFavorite(cls, dialog.getCurrent(), name);
        this.m_ListModelSuperclass.update();
        this.m_ListModelFavorites.update();
    }

    protected void editFavorite(Class cls, String entry) {
        String name = entry.substring(0, entry.indexOf(SEPARATOR));
        Favorites.Favorite favorite = this.m_Favorites.getFavorite(cls, name);
        if (favorite == null) {
            return;
        }
        GenericObjectEditorDialog dialog = this.getGOEEditor();
        dialog.setTitle("Edit Favorite (" + name + ")");
        dialog.getGOEEditor().setClassType(cls);
        dialog.setCurrent(favorite.getObject());
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        this.m_Favorites.addFavorite(cls, dialog.getCurrent(), name);
        this.m_ListModelSuperclass.update();
        this.m_ListModelFavorites.update();
    }

    protected void renameFavorite(Class cls, String entry) {
        String name = entry.substring(0, entry.indexOf(SEPARATOR));
        Favorites.Favorite favorite = this.m_Favorites.getFavorite(cls, name);
        String newName = JOptionPane.showInputDialog("Please input new name:", (Object)name);
        if (newName == null) {
            return;
        }
        this.m_Favorites.addFavorite(cls, favorite.getObject(), newName);
        this.m_Favorites.removeFavorite(cls, name);
        this.m_ListModelFavorites.update();
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            if (this.getParentFrame() != null) {
                JFrame frame = (JFrame)this.getParentFrame();
                frame.setDefaultCloseOperation(0);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FavoritesManagementPanel.this.close();
                    }
                });
            } else if (this.getParentDialog() != null) {
                JDialog dialog = (JDialog)this.getParentDialog();
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FavoritesManagementPanel.this.close();
                    }
                });
            }
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FavoritesManagementPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Save");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
            menuitem.setIcon(GUIHelper.getIcon("save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FavoritesManagementPanel.this.save();
                }
            });
            this.m_MenuItemSave = menuitem;
            menuitem = new JMenuItem("Revert");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setIcon(GUIHelper.getIcon("refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FavoritesManagementPanel.this.revert();
                }
            });
            this.m_MenuItemRevert = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FavoritesManagementPanel.this.close();
                }
            });
            this.m_MenuItemClose = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateTitle() {
        String title = "Favorites management";
        if (this.m_Favorites.isModified()) {
            title = "*" + title;
        }
        this.setParentTitle(title);
    }

    protected void updateMenu() {
        this.updateTitle();
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemSave.setEnabled(this.m_Favorites.isModified());
        this.m_MenuItemRevert.setEnabled(this.m_Favorites.isModified());
        this.m_MenuItemClose.setEnabled(true);
    }

    protected void updateButtons() {
        this.m_ButtonSuperclassAdd.setEnabled(true);
        this.m_ButtonSuperclassRemove.setEnabled(this.m_PanelSuperclasses.getSelectedIndices().length > 0);
        this.m_ButtonSuperclassRemoveAll.setEnabled(this.m_PanelSuperclasses.getModel().getSize() > 0);
        this.m_ButtonFavoriteAdd.setEnabled(true);
        this.m_ButtonFavoriteEdit.setEnabled(this.m_PanelFavorites.getSelectedIndices().length == 1);
        this.m_ButtonFavoriteRename.setEnabled(this.m_PanelFavorites.getSelectedIndices().length == 1);
        this.m_ButtonFavoriteRemove.setEnabled(this.m_PanelFavorites.getSelectedIndices().length > 0);
        this.m_ButtonFavoriteRemoveAll.setEnabled(this.m_PanelFavorites.getModel().getSize() > 0);
    }

    protected void update() {
        this.updateMenu();
        this.updateTitle();
        this.updateButtons();
    }

    protected boolean checkForModified() {
        boolean result;
        boolean bl = result = !this.m_Favorites.isModified();
        if (!result) {
            int retVal = JOptionPane.showConfirmDialog(this, "Favorites are modified - save?", "Favorites modified", 1);
            switch (retVal) {
                case 0: {
                    this.save();
                    result = !this.m_Favorites.isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    protected void save() {
        if (!this.m_Favorites.updateFavorites()) {
            GUIHelper.showErrorMessage(this, "Error saving favorites to '" + this.m_Favorites.getFilename() + "'!", "Error saving favorites");
        } else {
            Favorites.reload();
            GUIHelper.showInformationMessage(this, "Favorites have been successfully saved to '" + this.m_Favorites.getFilename() + "'!", "Favorites saved");
        }
        this.update();
    }

    protected void revert() {
        this.m_Favorites = Favorites.getSingleton().getClone();
        this.m_Favorites.setAutoSave(false);
        this.m_ListModelSuperclass.setFavorites(this.m_Favorites);
        this.m_ListModelFavorites.setFavorites(this.m_Favorites);
        this.update();
    }

    protected void close() {
        if (!this.checkForModified()) {
            if (this.getParentDialog() != null) {
                this.getParentDialog().setVisible(true);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(true);
            }
            return;
        }
        if (this.getParentFrame() != null) {
            ((JFrame)this.getParentFrame()).setDefaultCloseOperation(2);
        }
        this.closeParent();
    }

    public static class FavoritesListModel
    extends AbstractFavoritesListModel {
        private static final long serialVersionUID = -4331009712660382052L;
        protected Class m_Superclass;

        public FavoritesListModel() {
        }

        public FavoritesListModel(Favorites fav) {
            super(fav);
            this.setSuperclass((Class)null);
        }

        public FavoritesListModel(Favorites fav, Class cls) {
            super(fav);
            this.setSuperclass(cls);
        }

        public void setSuperclass(String value) {
            try {
                this.setSuperclass(Class.forName(value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setSuperclass(Class value) {
            if (value == null) {
                Vector<String> classes = this.m_Favorites.getSuperclasses();
                if (classes.size() > 0) {
                    this.setSuperclass(classes.firstElement());
                    return;
                }
            } else {
                this.m_Superclass = value;
            }
            this.update();
        }

        public Class getSuperclass() {
            return this.m_Superclass;
        }

        @Override
        public void update() {
            this.clear();
            if (this.m_Superclass != null) {
                Vector<Favorites.Favorite> favorites = this.m_Favorites.getFavorites(this.m_Superclass);
                for (int i = 0; i < favorites.size(); ++i) {
                    this.addElement(favorites.get(i).getName() + FavoritesManagementPanel.SEPARATOR + favorites.get(i).getCommandline());
                }
            }
        }
    }

    public static class SuperclassListModel
    extends AbstractFavoritesListModel {
        private static final long serialVersionUID = -744836869993575297L;

        public SuperclassListModel() {
        }

        public SuperclassListModel(Favorites fav) {
            super(fav);
        }

        @Override
        public void update() {
            this.clear();
            Vector<String> classes = this.m_Favorites.getSuperclasses();
            for (int i = 0; i < classes.size(); ++i) {
                this.addElement(classes.get(i));
            }
        }

        @Override
        public Favorites getFavorites() {
            return this.m_Favorites;
        }
    }

    public static abstract class AbstractFavoritesListModel
    extends DefaultListModel {
        private static final long serialVersionUID = -4439263856723765375L;
        protected Favorites m_Favorites;

        public AbstractFavoritesListModel() {
            this(new Favorites(false));
        }

        public AbstractFavoritesListModel(Favorites fav) {
            this.setFavorites(fav);
        }

        public void setFavorites(Favorites value) {
            this.m_Favorites = value;
            this.update();
        }

        public Favorites getFavorites() {
            return this.m_Favorites;
        }

        public abstract void update();
    }
}

