/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template.statements;

import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.template.TemplateException;
import org.jopendocument.dom.template.statements.Statement;
import org.jopendocument.util.JDOMUtils;

public abstract class BaseStatement
extends Statement {
    private static String scriptLang = "JODScript";

    public static void setScriptLang(String string) {
        scriptLang = string;
    }

    public BaseStatement(String string) {
        super(string);
    }

    @Override
    public boolean matches(Element element) {
        return element.getName().equals("script") && element.getNamespacePrefix().equals("text") && element.getAttributeValue("language", element.getNamespace("script")).equals(scriptLang) && element.getText().trim().startsWith("<" + this.getName());
    }

    @Override
    public void prepare(Element element) throws TemplateException {
        this.prepare(element, this.parseScript(element.getText()));
    }

    protected abstract void prepare(Element var1, Element var2) throws TemplateException;

    private Element parseScript(String string) throws TemplateException {
        Element element = null;
        try {
            element = JDOMUtils.parseElementString(string, new Namespace[0]);
        }
        catch (Exception exception) {
            throw new TemplateException("invalid script: " + string, exception);
        }
        return element;
    }

    protected static void removeSection(Element element) {
        if (element.getQualifiedName().equals("text:section")) {
            BaseStatement.pullUp(element);
        }
    }
}

