/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.clusterers.UpdateableClusterer;
import weka.core.Instance;
import weka.core.Instances;

public class WekaClusterer
extends AbstractTransformer {
    private static final long serialVersionUID = -3019442578354930841L;
    public static final String BACKUP_INCREMENTALCLUSTERER = "incremental clusterer";
    protected Clusterer m_Clusterer;
    protected Clusterer m_IncrementalClusterer;

    public String globalInfo() {
        return "Trains a clusterer based on the incoming dataset and output the built clusterer alongside the training header (in a model container).\nIncremental training is performed, if the input are weka.core.Instance objects and the clusterer implements " + UpdateableClusterer.class.getName() + ".\n" + "If the incoming token does not encapsulate a dataset, then only a " + "new instance of the clusterer is sent around.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("clusterer", "clusterer", (Object)new SimpleKMeans());
    }

    public void setClusterer(Clusterer value) {
        this.m_Clusterer = value;
        this.reset();
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The Weka clusterer to train on the input data.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("clusterer");
        if (variable != null) {
            return variable;
        }
        if (this.m_Clusterer != null) {
            return this.m_Clusterer.getClass().getName().replace("weka.clusterers.", "");
        }
        return null;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INCREMENTALCLUSTERER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_IncrementalClusterer != null) {
            result.put(BACKUP_INCREMENTALCLUSTERER, this.m_IncrementalClusterer);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INCREMENTALCLUSTERER)) {
            this.m_IncrementalClusterer = (Clusterer)state.get(BACKUP_INCREMENTALCLUSTERER);
            state.remove(BACKUP_INCREMENTALCLUSTERER);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_IncrementalClusterer = null;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, Instance.class, Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class, Clusterer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instances) {
                Instances data = (Instances)this.m_InputToken.getPayload();
                Clusterer cls = (Clusterer)Utils.deepCopy((Object)this.m_Clusterer);
                cls.buildClusterer(data);
                this.m_OutputToken = new Token((Object)new WekaModelContainer(cls, new Instances(data, 0)));
            } else if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instance) {
                if (!(this.m_Clusterer instanceof UpdateableClusterer)) {
                    result = this.m_Clusterer.getClass().getName() + " is not an incremental clusterer!";
                } else {
                    Instance inst = (Instance)this.m_InputToken.getPayload();
                    if (this.m_IncrementalClusterer == null) {
                        this.m_IncrementalClusterer = AbstractClusterer.makeCopy((Clusterer)this.m_Clusterer);
                        Instances data = new Instances(inst.dataset(), 1);
                        data.add((Instance)inst.copy());
                        this.m_IncrementalClusterer.buildClusterer(data);
                    } else {
                        ((UpdateableClusterer)this.m_IncrementalClusterer).updateClusterer(inst);
                        ((UpdateableClusterer)this.m_IncrementalClusterer).updateFinished();
                    }
                    this.m_OutputToken = new Token((Object)new WekaModelContainer(this.m_IncrementalClusterer, new Instances(inst.dataset(), 0)));
                }
            } else {
                Clusterer cls = (Clusterer)Utils.deepCopy((Object)this.m_Clusterer);
                this.m_OutputToken = new Token((Object)cls);
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = e.toString();
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }
}

