/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableClassifier;
import weka.classifiers.trees.Node;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomModelTrees
extends RandomizableClassifier
implements OptionHandler,
WeightedInstancesHandler {
    private static final long serialVersionUID = -3131038090987633675L;
    protected Node[] m_node;
    protected int m_numIterations = 0;
    protected int m_max = 0;
    protected Instances m_data = null;
    protected int m_numTrials = 0;
    protected double m_ridge = 0.0;

    public String globalInfo() {
        return "RandomModelTrees: work on raw input (no preprocesssing whatsoever)\ndoes not even center the class-value (???)\nuses straight LinearRegression in leaves";
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tThe number of attrs to try. (0 = 5)", "K", 1, "-K <int>"));
        newVector.addElement(new Option("\tThe ridge value for regression. (0.0 = 0.001 for M==2, 0.0001 else)", "R", 1, "-R <double>"));
        newVector.addElement(new Option("\tNumber of trees.\n\t(default 0 = 250)", "N", 1, "-N <num>"));
        newVector.addElement(new Option("\t Max Tree Height.\n\t(default 0 = max(2, log2(#ex)-log2(#attr)-1))", "M", 1, "-M <num>"));
        Enumeration enum1 = super.listOptions();
        while (enum1.hasMoreElements()) {
            newVector.addElement(enum1.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String iterations = Utils.getOption((char)'N', (String[])options);
        if (iterations.length() != 0) {
            this.setNumIterations(Integer.parseInt(iterations));
        } else {
            this.setNumIterations(0);
        }
        iterations = Utils.getOption((char)'M', (String[])options);
        if (iterations.length() != 0) {
            this.setMax(Integer.parseInt(iterations));
        } else {
            this.setMax(0);
        }
        String tmpStr = Utils.getOption((char)'K', (String[])options);
        if (tmpStr.length() > 0) {
            this.setTrials(Integer.parseInt(tmpStr));
        } else {
            this.setTrials(0);
        }
        tmpStr = Utils.getOption((char)'R', (String[])options);
        if (tmpStr.length() > 0) {
            this.setRidge(Double.parseDouble(tmpStr));
        } else {
            this.setRidge(0.0);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 8];
        options[0] = "-K";
        options[1] = "" + this.getTrials();
        options[2] = "-M";
        options[3] = "" + this.getMax();
        options[4] = "-N";
        options[5] = "" + this.getNumIterations();
        options[6] = "-R";
        options[7] = "" + this.getRidge();
        System.arraycopy(superOptions, 0, options, 8, superOptions.length);
        return options;
    }

    public int getTrials() {
        return this.m_numTrials;
    }

    public void setTrials(int n) {
        this.m_numTrials = n;
    }

    public String trialsTipText() {
        return "The number of trials.";
    }

    public double getRidge() {
        return this.m_ridge;
    }

    public void setRidge(double c) {
        this.m_ridge = c;
    }

    public String ridgeTipText() {
        return "The ridge to use.";
    }

    public void setNumIterations(int numIterations) {
        this.m_numIterations = numIterations;
    }

    public int getNumIterations() {
        return this.m_numIterations;
    }

    public String numIterationsTipText() {
        return "The number of iterations.";
    }

    public int getMax() {
        return this.m_max;
    }

    public void setMax(int n) {
        this.m_max = n;
    }

    public String maxTipText() {
        return "The maximum height of the trees.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        double ridge;
        int maxHeight;
        this.getCapabilities().testWithFail(data);
        this.m_data = new Instances(data, 0);
        int numIterations = this.getNumIterations();
        if (numIterations == 0) {
            numIterations = 250;
        }
        this.m_node = new Node[numIterations];
        Random r = new Random(this.getSeed());
        int n = data.numInstances();
        ArrayList<Instance> all = new ArrayList<Instance>(n);
        for (int i = 0; i < n; ++i) {
            all.add(data.instance(i));
        }
        int trials = this.getTrials();
        if (trials == 0) {
            trials = 5;
        }
        if ((maxHeight = this.getMax()) == 0) {
            int nn = Integer.bitCount(Integer.highestOneBit(n) - 1);
            int aa = Integer.bitCount(Integer.highestOneBit(data.numAttributes() - 1) - 1);
            if (this.getDebug()) {
                System.out.println("n " + n + " " + nn);
                System.out.println("a " + (data.numAttributes() - 1) + " " + aa);
            }
            if ((maxHeight = nn - aa - 1) < 2) {
                maxHeight = 2;
            }
        }
        if ((ridge = this.getRidge()) <= 0.0) {
            ridge = maxHeight == 2 ? 0.001 : 1.0E-4;
        }
        if (this.getDebug()) {
            System.out.println("effective parameters: n = " + numIterations + " r = " + ridge + " k = " + trials + " m = " + maxHeight);
        }
        Comparator<Instance>[] comparators = this.getComparators(data.numAttributes());
        for (int j = 0; j < this.m_node.length; ++j) {
            this.m_node[j] = new Node(all, r, maxHeight, ridge, trials, comparators);
        }
    }

    public Comparator<Instance>[] getComparators(int k) {
        Comparator[] comparators = new Comparator[k];
        for (int i = 0; i < k; ++i) {
            final int comparisonIndex = i;
            comparators[i] = new Comparator<Instance>(){

                @Override
                public int compare(Instance x1, Instance x2) {
                    double v2;
                    double v1 = x1.value(comparisonIndex);
                    if (v1 < (v2 = x2.value(comparisonIndex))) {
                        return -1;
                    }
                    if (v1 > v2) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
        return comparators;
    }

    public double classifyInstance(Instance instance) throws Exception {
        double sum = 0.0;
        for (Node node : this.m_node) {
            sum += node.classifyInstance(instance);
        }
        double result = sum / (double)this.m_node.length;
        if (this.getDebug()) {
            System.out.println("xxx " + result);
        }
        return result;
    }

    public String toStringOLD() {
        if (this.m_node == null) {
            return "RandomModelTrees: No model built yet.";
        }
        StringBuffer text = new StringBuffer();
        text.append("RandomModelTrees: \n\n");
        for (Node node : this.m_node) {
            node.toString(0, text, this.m_data);
            text.append("\n\n");
            text.append("-------------------------------------");
        }
        return text.toString();
    }

    public String toString() {
        if (this.m_node == null) {
            return "RandomModelTrees: No model built yet.";
        }
        StringBuffer text = new StringBuffer();
        text.append("RandomModelTrees: \n\n");
        return text.toString();
    }

    public String getRevision() {
        return "$Revision: 1487 $";
    }

    public static void main(String[] argv) {
        RandomModelTrees.runClassifier((Classifier)new RandomModelTrees(), (String[])argv);
    }
}

