/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.unsupervised.attribute.Add;
import weka.filters.unsupervised.attribute.AddExpression;
import weka.filters.unsupervised.attribute.Center;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class MultiFilterTest
extends AbstractFilterTest {
    public MultiFilterTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        return new MultiFilter();
    }

    public Filter getConfiguredFilter() {
        MultiFilter result = new MultiFilter();
        Filter[] filters = new Filter[2];
        filters[0] = new Add();
        ((Add)filters[0]).setAttributeIndex("last");
        filters[1] = new AddExpression();
        ((AddExpression)filters[1]).setExpression("a3+a6");
        result.setFilters(filters);
        return result;
    }

    public Filter getConfiguredFilterVariant() {
        MultiFilter result = new MultiFilter();
        Filter[] filters = new Filter[]{new ReplaceMissingValues(), new Center()};
        result.setFilters(filters);
        return result;
    }

    public void testDefault() {
        Instances result = this.useFilter();
        MultiFilterTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MultiFilterTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
    }

    public void testConfigured() {
        this.m_Filter = this.getConfiguredFilter();
        Instances result = this.useFilter();
        MultiFilterTest.assertEquals((int)(this.m_Instances.numAttributes() + 2), (int)result.numAttributes());
        MultiFilterTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
    }

    public void testConfiguredVariant() {
        this.m_Filter = this.getConfiguredFilterVariant();
        Instances result = this.useFilter();
        MultiFilterTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MultiFilterTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
    }

    public static Test suite() {
        return new TestSuite(MultiFilterTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MultiFilterTest.suite());
    }
}

