/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeLongLP64Type;
import de.intarsys.nativec.type.NativeNumber;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;

public class NativeLongLP64
extends NativeNumber {
    public static final NativeLongLP64Type META = new NativeLongLP64Type();

    static {
        NativeType.register(NativeLongLP64.class, META);
    }

    public static NativeLongLP64 createFromAddress(long address) {
        return (NativeLongLP64)META.createNative(NativeTools.toHandle(address));
    }

    public NativeLongLP64() {
        this.allocate();
    }

    protected NativeLongLP64(INativeHandle handle) {
        super(handle);
    }

    public NativeLongLP64(long value) {
        this.allocate();
        this.setValue(value);
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public INativeType getNativeType() {
        return META;
    }

    public Object getValue() {
        return new Long(this.longValue());
    }

    public int intValue() {
        return (int)this.longValue();
    }

    public long longValue() {
        if (NativeObject.SIZE_PTR == 4) {
            return this.handle.getInt(0);
        }
        return this.handle.getLong(0);
    }

    public void setValue(long value) {
        if (NativeObject.SIZE_PTR == 4) {
            this.handle.setInt(0, (int)value);
            return;
        }
        this.handle.setLong(0, value);
    }

    public void setValue(Object value) {
        this.setValue(((Number)value).longValue());
    }

    public short shortValue() {
        return (short)this.longValue();
    }

    public String toString() {
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.longValue());
    }
}

