/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core;

import java.io.Serializable;
import java.util.Arrays;

public class Coordinates
implements Serializable {
    private static final long serialVersionUID = 8361257560328772093L;
    public static final int Y = 0;
    public static final int X = 1;
    public static final int Z = 2;
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    public static final int ALL = Integer.MAX_VALUE;
    public static final long[] ZERO2D = new long[2];
    public long[] co;

    public Coordinates(long ... dimensions) {
        this.co = new long[dimensions.length];
        System.arraycopy(dimensions, 0, this.co, 0, dimensions.length);
    }

    public Coordinates(Coordinates c) {
        this.co = new long[c.co.length];
        System.arraycopy(c.co, 0, this.co, 0, c.co.length);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.co);
    }

    public boolean equals(Coordinates c) {
        return Arrays.equals(this.co, c.co);
    }

    public static long product(long[] c) {
        long product = 1L;
        int i = c.length - 1;
        while (i != -1) {
            product *= c[i];
            --i;
        }
        return product;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        int i = 0;
        while (i < this.co.length) {
            s.append(this.co[i]);
            if (i < this.co.length - 1) {
                s.append(", ");
            }
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Coordinates) {
            return this.equals((Coordinates)o);
        }
        return false;
    }

    public void fillWithValue(long value) {
        Arrays.fill(this.co, value);
    }

    public void clear() {
        Arrays.fill(this.co, 0L);
    }

    public static String toString(long ... coordinates) {
        return Coordinates.toString(',', coordinates);
    }

    public static String toString(char separator, long ... coordinates) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < coordinates.length) {
            buf.append(coordinates[i]);
            if (i < coordinates.length - 1) {
                buf.append(separator);
            }
            ++i;
        }
        return buf.toString();
    }

    public Coordinates clone() {
        Coordinates c = new Coordinates(this);
        return c;
    }

    public static final long[] plus(long[] c1, long[] c2) {
        long[] co = Coordinates.copyOf(c1);
        int i = co.length - 1;
        while (i != -1) {
            int n = i;
            co[n] = co[n] + c2[i];
            --i;
        }
        return co;
    }

    public static final long[] multiply(long[] c1, long[] c2) {
        long[] co = Coordinates.copyOf(c1);
        int i = co.length - 1;
        while (i != -1) {
            int n = i;
            co[n] = co[n] * c2[i];
            --i;
        }
        return co;
    }

    public static final long[] modulo(long[] c1, long[] c2) {
        long[] co = new long[c1.length];
        int i = co.length - 1;
        while (i != -1) {
            co[i] = c1[i] % c2[i];
            --i;
        }
        return co;
    }

    public static final long[] minus(long[] c1, long[] c2) {
        long[] co = Coordinates.copyOf(c1);
        int i = co.length - 1;
        while (i != -1) {
            int n = i;
            co[n] = co[n] - c2[i];
            --i;
        }
        return co;
    }

    public static final long[] max(long[] c1, long[] c2) {
        long[] co = Coordinates.copyOf(c1);
        int i = co.length - 1;
        while (i != -1) {
            if (c2[i] > co[i]) {
                co[i] = c2[i];
            }
            --i;
        }
        return co;
    }

    public static final long[] min(long[] c1, long[] c2) {
        long[] co = Coordinates.copyOf(c1);
        int i = co.length - 1;
        while (i != -1) {
            if (c2[i] < co[i]) {
                co[i] = c2[i];
            }
            --i;
        }
        return co;
    }

    public static long[] parseString(String s) {
        String[] fields = s.split("[,;\tx]");
        long[] dims = new long[fields.length];
        int i = fields.length - 1;
        while (i != -1) {
            dims[i] = Long.parseLong(fields[i]);
            --i;
        }
        return dims;
    }

    public int getDimensionCount() {
        return this.co.length;
    }

    public static final boolean equals(long[] c1, long[] c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1.length != c2.length) {
            return false;
        }
        int i = 0;
        while (i < c1.length) {
            if (c1[i] != c2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static long[] copyOf(long[] c) {
        long[] ret = new long[c.length];
        System.arraycopy(c, 0, ret, 0, c.length);
        return ret;
    }

    public static final long[] transpose(long[] c) {
        long[] copy = Coordinates.copyOf(c);
        copy[0] = c[1];
        copy[1] = c[0];
        return copy;
    }

    public static final long[] transpose(long[] c, int swap1, int swap2) {
        long[] copy = Coordinates.copyOf(c);
        copy[swap1] = c[swap2];
        copy[swap2] = c[swap1];
        return copy;
    }

    public static boolean isInsideOf(long[] coordinates, long[] position, long[] size) {
        if (coordinates[0] < position[0]) {
            return false;
        }
        if (coordinates[1] < position[1]) {
            return false;
        }
        long[] secondCorner = Coordinates.plus(position, size);
        if (coordinates[0] >= secondCorner[0]) {
            return false;
        }
        return coordinates[1] < secondCorner[1];
    }

    public static boolean isSmallerThan(long[] coordinates, long[] size) {
        int i = coordinates.length - 1;
        while (i != -1) {
            if (coordinates[i] >= size[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean isSmallerOrEqual(long[] coordinates, long[] size) {
        int i = coordinates.length - 1;
        while (i != -1) {
            if (coordinates[i] > size[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static long[] minusOne(long[] coordinates) {
        long[] ret = new long[coordinates.length];
        int i = coordinates.length - 1;
        while (i != -1) {
            ret[i] = coordinates[i] - 1L;
            --i;
        }
        return ret;
    }

    public static boolean isZero(long[] coordinates) {
        int i = coordinates.length - 1;
        while (i != -1) {
            if (coordinates[i] != 0L) {
                return false;
            }
            --i;
        }
        return true;
    }
}

