/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.floatmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.floatmatrix.stub.AbstractDenseFloatMatrix2D;

public class ArrayDenseFloatMatrix2D
extends AbstractDenseFloatMatrix2D {
    private static final long serialVersionUID = 6599658021180126741L;
    private float[][] values = null;

    public ArrayDenseFloatMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof ArrayDenseFloatMatrix2D) {
            float[][] v = ((ArrayDenseFloatMatrix2D)m).values;
            this.values = new float[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new float[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsFloat(m.getAsFloat(c), c);
            }
        }
    }

    public ArrayDenseFloatMatrix2D(float[] ... v) {
        this.values = v;
    }

    public ArrayDenseFloatMatrix2D(long ... size) {
        this.values = new float[(int)size[0]][(int)size[1]];
    }

    public ArrayDenseFloatMatrix2D(float[] v) {
        this.values = new float[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public float getFloat(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setFloat(float value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public float getFloat(int row, int column) {
        return this.values[row][column];
    }

    public void setFloat(float value, int row, int column) {
        this.values[row][column] = value;
    }

    public final Matrix transpose() {
        float[][] result = new float[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new ArrayDenseFloatMatrix2D(result);
    }
}

