/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.Collection;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Concatenation
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -2428322597419645314L;
    private long[] positions = null;
    private long[] size = Coordinates.ZERO2D;
    private ValueType valueType = null;

    public Concatenation(int dimension, Matrix ... matrices) {
        super(dimension, matrices);
        this.valueType = matrices[0].getValueType();
        this.positions = new long[matrices.length];
        long pos = 0L;
        int i = 0;
        while (i < matrices.length) {
            Matrix m = matrices[i];
            if (!this.valueType.equals((Object)m.getValueType())) {
                this.valueType = ValueType.OBJECT;
            }
            this.positions[i] = pos;
            pos += m.getSize(dimension);
            this.size = Coordinates.max(this.size, m.getSize());
            ++i;
        }
        this.size[dimension] = pos;
    }

    public Concatenation(int dimension, Collection<Matrix> matrices) {
        this(dimension, matrices.toArray(new Matrix[matrices.size()]));
    }

    @Override
    public Object getObject(long ... coordinates) throws MatrixException {
        int i = 0;
        while (i < this.positions.length) {
            if (this.positions[i] > coordinates[this.getDimension()]) break;
            ++i;
        }
        Matrix m = this.getSources()[--i];
        long[] c = Coordinates.copyOf(coordinates);
        c[this.getDimension()] = c[this.getDimension()] - this.positions[i];
        return m.getAsObject(c);
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public void setObject(Object value, long ... coordinates) throws MatrixException {
    }

    @Override
    public final ValueType getValueType() {
        return this.valueType;
    }
}

