/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.AbstractXRefParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STTrailerXRefSection;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XRefFallbackParser
extends AbstractXRefParser {
    private STTrailerXRefSection xRefSection;
    private List trailers = new ArrayList();

    public XRefFallbackParser(STDocument doc, COSDocumentParser parser) {
        super(doc, parser);
        this.xRefSection = new STTrailerXRefSection(doc);
    }

    private void checkXRefSections() throws IOException, COSLoadException {
        if (this.trailers.isEmpty()) {
            COSLoadError e = new COSLoadError("no trailer found");
            this.handleError(e);
        }
        boolean rootFound = false;
        int i = this.trailers.size() - 1;
        while (i >= 0) {
            COSDictionary trailer = (COSDictionary)this.trailers.get(i);
            if (trailer.containsKey(COSTrailer.DK_Root)) {
                this.getXRefSection().cosSetDict(trailer);
                rootFound = true;
                break;
            }
            --i;
        }
        if (!rootFound) {
            COSLoadError e = new COSLoadError("trailer doesn't contain a root entry");
            this.handleError(e);
        }
        this.getXRefSection().setSize(this.getXRefSection().getMaxObjectNumber());
    }

    protected STTrailerXRefSection getXRefSection() {
        return this.xRefSection;
    }

    public STXRefSection parse(IRandomAccess input) throws IOException, COSLoadException {
        input.seek(0L);
        while (this.readUptoNewLine(input)) {
            long offset = input.getOffset();
            try {
                COSDictionary trailer = this.getParser().parseTrailer(input);
                this.trailers.add(trailer);
                continue;
            }
            catch (IOException iOException) {
            }
            catch (COSLoadException cOSLoadException) {
                // empty catch block
            }
            try {
                int objNumber = this.getParser().readInteger(input, true);
                if (objNumber != 0) {
                    int genNumber = this.getParser().readInteger(input, true);
                    byte[] token = this.getParser().readToken(input);
                    if (Arrays.equals(PDFParser.TOKEN_obj, token)) {
                        this.getXRefSection().addEntry(new STXRefEntryOccupied(objNumber, genNumber, (int)offset));
                        continue;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            input.seek(offset);
        }
        this.checkXRefSections();
        return this.getXRefSection();
    }

    private boolean readUptoNewLine(IRandomAccess input) throws IOException {
        int i;
        do {
            if ((i = input.read()) != -1) continue;
            return false;
        } while (!PDFParser.isEOL(i));
        if (i == PDFParser.CHAR_CR) {
            i = input.read();
            if (i == -1) {
                return false;
            }
            if (i != PDFParser.CHAR_LF) {
                input.seekBy(-1L);
            }
        }
        return true;
    }
}

