/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Utils;
import adams.core.base.BaseText;
import adams.core.io.PlaceholderFile;
import adams.core.net.EmailAddress;
import adams.core.net.EmailHelper;
import adams.flow.core.NullToken;
import adams.flow.sink.AbstractSink;
import java.io.File;

public class Email
extends AbstractSink {
    private static final long serialVersionUID = -5959868605503747649L;
    protected EmailAddress[] m_Recipients;
    protected String m_Subject;
    protected BaseText m_Body;
    protected BaseText m_Signature;

    public String globalInfo() {
        return "Actor for sending emails. The (optional) attachments are taken from the input.\nVariables in 'subject', 'body' and 'signature' are automatically replaced whenever the actor is executed.\n" + (EmailHelper.isEnabled() ? "" : "Email support not enabled, check email setup!");
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("recipient", "recipients", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("subject", "subject", (Object)"");
        this.m_OptionManager.add("body", "body", (Object)new BaseText(""));
        this.m_OptionManager.add("signature", "signature", (Object)new BaseText(Utils.unbackQuoteChars((String)EmailHelper.getDefaultSignature())));
    }

    public String getQuickInfo() {
        if (!EmailHelper.isEnabled()) {
            return "No email support enabled, check email setup!";
        }
        String result = "<no recipients>";
        if (this.m_Recipients != null && this.m_Recipients.length > 0) {
            result = "";
            for (int i = 0; i < this.m_Recipients.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + this.m_Recipients[i].getValue();
            }
        }
        return result;
    }

    public void setRecipients(EmailAddress[] value) {
        this.m_Recipients = value;
        this.reset();
    }

    public EmailAddress[] getRecipients() {
        return this.m_Recipients;
    }

    public String recipientsTipText() {
        return "The recipients to send the email to.";
    }

    public void setSubject(String value) {
        this.m_Subject = value;
        this.reset();
    }

    public String getSubject() {
        return this.m_Subject;
    }

    public String subjectTipText() {
        return "The subject of the email.";
    }

    public void setBody(BaseText value) {
        this.m_Body = value;
        this.reset();
    }

    public BaseText getBody() {
        return this.m_Body;
    }

    public String bodyTipText() {
        return "The body of the email.";
    }

    public void setSignature(BaseText value) {
        this.m_Signature = value;
        this.reset();
    }

    public BaseText getSignature() {
        return this.m_Signature;
    }

    public String signatureTipText() {
        return "The signature of the email, gets separated by an extra line consisting of '--'.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !EmailHelper.isEnabled()) {
            result = "No email support enabled, check email setup!";
        }
        return result;
    }

    protected String doExecute() {
        int i;
        String result = null;
        File[] attachments = null;
        if (this.m_InputToken == null || this.m_InputToken instanceof NullToken) {
            attachments = new File[]{};
        } else if (this.m_InputToken.getPayload() instanceof File) {
            attachments = new File[]{(File)this.m_InputToken.getPayload()};
        } else if (this.m_InputToken.getPayload() instanceof File[]) {
            attachments = (File[])this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof String) {
            attachments = new File[]{new PlaceholderFile((String)this.m_InputToken.getPayload())};
        } else if (this.m_InputToken.getPayload() instanceof String[]) {
            attachments = new File[((String[])this.m_InputToken.getPayload()).length];
            for (i = 0; i < attachments.length; ++i) {
                attachments[i] = new PlaceholderFile(((String[])this.m_InputToken.getPayload())[i]);
            }
        }
        String[] recipients = new String[this.m_Recipients.length];
        for (i = 0; i < this.m_Recipients.length; ++i) {
            recipients[i] = this.m_Recipients[i].stringValue();
        }
        String subject = this.getVariables().expand(this.m_Subject);
        String body = this.getVariables().expand(this.m_Body.getValue());
        String signature = this.getVariables().expand(this.m_Signature.getValue());
        body = EmailHelper.combine(body, signature);
        if (this.isDebugOn()) {
            this.debug("#recipients: " + recipients.length + ", #attachments: " + attachments.length + ", subject: " + subject + ", len(body): " + body.length());
        }
        try {
            EmailHelper.sendMail(recipients, subject, body, attachments);
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace((Throwable)e);
            result = e.toString();
        }
        return result;
    }
}

