/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.SSHConnection;
import adams.flow.transformer.AbstractTransformer;
import com.jcraft.jsch.ChannelExec;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

@MixedCopyright(copyright="JCraft", license="BSD", url="http://www.jcraft.com/jsch/")
public class ScpTo
extends AbstractTransformer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_RemoteDir;
    protected SSHConnection m_Connection;

    public String globalInfo() {
        return "Uploads a file to a remote directory using secure copy (SCP).\nThe file name of a successful upload gets forwarded.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.TITLE, "JSch - JSch is a pure Java implementation of SSH2.");
        result.setValue(TechnicalInformation.Field.HTTP, "http://www.jcraft.com/jsch/");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/pub");
    }

    public String getQuickInfo() {
        String result = "upload to  ";
        String variable = this.getOptionManager().getVariableForProperty("remoteDir");
        result = variable != null ? result + variable : result + this.m_RemoteDir;
        return result;
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The remote directory to upload the file to.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (SSHConnection)ActorUtils.findClosestType((AbstractActor)this, SSHConnection.class);
            if (this.m_Connection == null) {
                result = "No " + SSHConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        String filename = (String)this.m_InputToken.getPayload();
        PlaceholderFile file = new PlaceholderFile(filename);
        String remotefile = this.m_RemoteDir + "/" + file.getName();
        ChannelExec channel = null;
        try {
            int len;
            channel = (ChannelExec)this.m_Connection.getSession().openChannel("exec");
            channel.setCommand("scp -p -t " + remotefile);
            if (this.isDebugOn()) {
                this.debug("Uploading " + file + " to " + remotefile);
            }
            InputStream in = channel.getInputStream();
            OutputStream out = channel.getOutputStream();
            byte[] buffer = new byte[1024];
            channel.connect();
            if (SSHConnection.checkAck(in) != 0) {
                String string = result = "Input stream check failed after opening channel!";
                return string;
            }
            long filesize = file.length();
            String command = "C0644 " + filesize + " " + file.getName() + "\n";
            out.write(command.getBytes());
            out.flush();
            if (SSHConnection.checkAck(in) != 0) {
                result = "Sending of filename failed!";
            }
            FileInputStream fis = new FileInputStream(file.getAbsoluteFile());
            buffer = new byte[1024];
            while ((len = fis.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, len);
            }
            fis.close();
            fis = null;
            buffer[0] = 0;
            out.write(buffer, 0, 1);
            out.flush();
            if (SSHConnection.checkAck(in) != 0) {
                result = "Left-over data in input stream!";
            }
            out.close();
            if (result == null) {
                this.m_OutputToken = new Token((Object)filename);
            }
        }
        catch (Exception e) {
            String msg = "Failed to upload file '" + file + "' to '" + remotefile + "': ";
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace((Throwable)e);
            result = msg + e;
            this.m_OutputToken = null;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return result;
    }
}

