/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.annotation.MixedCopyright;
import adams.core.io.PdfFont;
import adams.env.Environment;
import adams.gui.chooser.PdfFontChooser;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.goe.PdfFontEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@MixedCopyright(author="Ian Darwin", copyright="1996-2002 Ian F. Darwin, http://www.darwinsys.com/", license="BSD (2-clause)", url="http://www.java2s.com/Code/Java/Tiny-Application/Afontselectiondialog.htm")
public class PdfFontChooserPanel
extends BasePanel {
    private static final long serialVersionUID = 4228582248866956387L;
    public static final Integer[] FONT_SIZES = new Integer[]{8, 10, 11, 12, 14, 16, 18, 20, 24, 30, 36, 40, 48, 60, 72};
    public static final String[] FONT_FAMILIES = new String[]{"Courier", "Helvetica", "Symbol", "Times Roman", "ZapfDingBats"};
    public static final String[] FONT_FACES = new String[]{"Italic", "Bold", "Underline", "StrikeThru"};
    public static final String DEFAULT_FONT = "Helvetica";
    public static final Integer DEFAULT_SIZE = 12;
    protected PdfFont m_Current;
    protected JList m_ListFontName;
    protected JList m_ListFontSize;
    protected JList m_ListFontFace;
    protected JTextArea m_TextSample;
    protected boolean m_IgnoreUpdates;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panelFonts = new JPanel(new BorderLayout(5, 5));
        panelFonts.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.add(panelFonts, "North");
        this.m_ListFontName = new JList<String>(FONT_FAMILIES);
        this.m_ListFontName.setSelectionMode(0);
        this.m_ListFontName.setSelectedIndex(0);
        this.m_ListFontName.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PdfFontChooserPanel.this.m_IgnoreUpdates) {
                    return;
                }
                if (PdfFontChooserPanel.this.m_ListFontName.getSelectedIndex() == -1) {
                    PdfFontChooserPanel.this.m_ListFontName.setSelectedIndex(0);
                } else {
                    PdfFontChooserPanel.this.previewFont();
                }
            }
        });
        panelFonts.add((Component)new BaseScrollPane((Component)this.m_ListFontName), "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panelFonts.add((Component)panel, "East");
        JPanel panelSize = new JPanel(new BorderLayout());
        panel.add((Component)panelSize, "West");
        this.m_ListFontSize = new JList<Integer>(FONT_SIZES);
        this.m_ListFontSize.setSelectionMode(0);
        this.m_ListFontSize.setSelectedValue(DEFAULT_SIZE, true);
        this.m_ListFontSize.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PdfFontChooserPanel.this.m_IgnoreUpdates) {
                    return;
                }
                if (PdfFontChooserPanel.this.m_ListFontSize.getSelectedIndices().length == 0) {
                    PdfFontChooserPanel.this.m_ListFontSize.setSelectedValue(DEFAULT_SIZE, true);
                } else {
                    PdfFontChooserPanel.this.previewFont();
                }
            }
        });
        BaseScrollPane scrollPane = new BaseScrollPane((Component)this.m_ListFontSize);
        scrollPane.setPreferredSize(new Dimension(50, 0));
        panelSize.add((Component)scrollPane);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel.add((Component)panel2, "Center");
        JPanel panelAttributes = new JPanel(new BorderLayout());
        panelAttributes.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        panel2.add((Component)panelAttributes, "West");
        this.m_ListFontFace = new JList<String>(FONT_FACES);
        this.m_ListFontFace.setSelectedValue(DEFAULT_FONT, true);
        this.m_ListFontFace.setSelectionMode(2);
        this.m_ListFontFace.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PdfFontChooserPanel.this.m_IgnoreUpdates) {
                    return;
                }
                PdfFontChooserPanel.this.previewFont();
            }
        });
        scrollPane = new BaseScrollPane((Component)this.m_ListFontFace);
        scrollPane.setPreferredSize(new Dimension(100, 0));
        panelAttributes.add((Component)scrollPane, "Center");
        this.m_TextSample = new JTextArea("The quick brown fox jumps over the lazy dog.");
        this.m_TextSample.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.m_TextSample.setColumns(30);
        this.m_TextSample.setRows(5);
        this.m_TextSample.setLineWrap(true);
        this.m_TextSample.setWrapStyleWord(true);
        this.m_TextSample.setEditable(false);
        this.add((Component)new BaseScrollPane((Component)this.m_TextSample), "Center");
        this.previewFont();
    }

    protected PdfFont createFont() {
        int family = PdfFont.getFontFamily((String)this.m_ListFontName.getSelectedValue());
        int style = 0;
        Object[] styles = this.m_ListFontFace.getSelectedValues();
        for (int i = 0; i < styles.length; ++i) {
            style |= PdfFont.getFontFace((String)styles[i]);
        }
        return new PdfFont(family, style, (float)((Integer)this.m_ListFontSize.getSelectedValue()).intValue());
    }

    protected void previewFont() {
        this.m_Current = this.createFont();
        this.m_TextSample.setFont(this.m_Current.toJavaFont());
    }

    public void setCurrent(PdfFont value) {
        int[] indices;
        this.m_IgnoreUpdates = true;
        if (value == null) {
            value = new PdfFont();
        }
        this.m_ListFontName.setSelectedValue(value.getFontFamilyName(), true);
        if (this.m_ListFontName.getSelectedIndex() == -1) {
            this.m_ListFontName.setSelectedValue(DEFAULT_FONT, true);
        }
        if (value.getFontFace() != 0 && value.getFontFace() != -1) {
            String[] styles = value.getFontFaces();
            indices = new int[styles.length];
            for (int i = 0; i < styles.length; ++i) {
                indices[i] = Arrays.binarySearch(FONT_FACES, styles[i]);
            }
        } else {
            indices = new int[]{};
        }
        this.m_ListFontFace.setSelectedIndices(indices);
        this.m_ListFontSize.setSelectedValue((int)value.getSize(), true);
        if (this.m_ListFontSize.getSelectedIndex() == -1) {
            this.m_ListFontSize.setSelectedValue(DEFAULT_SIZE, true);
        }
        this.m_IgnoreUpdates = false;
        this.previewFont();
    }

    public PdfFont getCurrent() {
        return this.m_Current;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        final BaseFrame frame = new BaseFrame("PDF FontChooser Startup");
        final PdfFontChooser chooser = new PdfFontChooser((Frame)frame);
        chooser.setCurrent(null);
        frame.getContentPane().setLayout(new GridLayout(0, 1));
        JButton button = new JButton("Change font");
        frame.getContentPane().add(button);
        final JLabel label = new JLabel("Java is great!", 0);
        frame.getContentPane().add(label);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooser.setVisible(true);
                PdfFont myNewFont = chooser.getCurrent();
                System.out.println("You chose " + PdfFontEditor.toString(null, myNewFont));
                label.setFont(myNewFont.toJavaFont());
                frame.pack();
                chooser.dispose();
            }
        });
        frame.setSize(150, 100);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

