/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.afm;

import java.util.StringTokenizer;

public class AFMChar {
    public static String AFM_TOKEN_WX = "WX";
    public static String AFM_TOKEN_W = "W";
    public static String AFM_TOKEN_W0X = "W0X";
    public static String AFM_TOKEN_W0 = "W0";
    public static String AFM_TOKEN_N = "N";
    public static String AFM_TOKEN_CH = "CH";
    public static String AFM_TOKEN_C = "C";
    private String name;
    private int code;
    private int width;

    public static AFMChar create(String glyph) {
        int code = -1;
        int width = -1;
        String name = "";
        StringTokenizer to = new StringTokenizer(glyph, ";");
        while (to.hasMoreTokens()) {
            StringTokenizer tf = new StringTokenizer(to.nextToken());
            if (!tf.hasMoreTokens()) continue;
            String field = tf.nextToken();
            if (field.equals(AFM_TOKEN_C)) {
                code = Integer.parseInt(tf.nextToken());
                continue;
            }
            if (field.equals(AFM_TOKEN_CH)) {
                String value = tf.nextToken();
                code = Integer.parseInt(value.substring(1, value.length() - 1), 16);
                continue;
            }
            if (field.equals(AFM_TOKEN_WX)) {
                width = Integer.parseInt(tf.nextToken());
                continue;
            }
            if (field.equals(AFM_TOKEN_W0X)) {
                width = Integer.parseInt(tf.nextToken());
                continue;
            }
            if (field.equals(AFM_TOKEN_W)) {
                width = Integer.parseInt(tf.nextToken());
                continue;
            }
            if (field.equals(AFM_TOKEN_W0)) {
                width = Integer.parseInt(tf.nextToken());
                continue;
            }
            if (!field.equals(AFM_TOKEN_N)) continue;
            name = tf.nextToken();
        }
        return new AFMChar(code, width, name);
    }

    protected AFMChar(int code, int width, String name) {
        this.setCode(code);
        this.setWidth(width);
        this.setName(name);
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    private void setCode(int newCode) {
        this.code = newCode;
    }

    private void setName(String newName) {
        this.name = newName;
    }

    private void setWidth(int newWidth) {
        this.width = newWidth;
    }

    public String toString() {
        return "<" + this.getCode() + ", " + this.getWidth() + ", " + this.getName() + ">";
    }
}

