/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.source.RSource;
import adams.flow.standalone.RServe;
import adams.flow.transformer.AbstractTransformer;

public class RTransformer
extends AbstractTransformer {
    private static final long serialVersionUID = -2595028152021378207L;
    protected String m_rScript;
    protected RSource.DataType m_returnType;
    protected Object m_returnedObject;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("r-Script", "rScript", (Object)"");
        this.m_OptionManager.add("return-type", "returnType", (Object)RSource.DataType.Integer);
    }

    public void setReturnType(RSource.DataType val) {
        this.m_returnType = val;
        this.reset();
    }

    public RSource.DataType getReturnType() {
        return this.m_returnType;
    }

    public String returnTypeTipText() {
        return "Data type of returned object";
    }

    public void setRScript(String val) {
        this.m_rScript = val;
        this.reset();
    }

    public String getRScript() {
        return this.m_rScript;
    }

    public String rScriptTipText() {
        return "Script to pass into r";
    }

    public Class[] accepts() {
        Class[] accepted = new Class[]{Integer.class, Integer[].class, Integer[][].class, Double.class, Double[].class, Double[][].class};
        return accepted;
    }

    public Class[] generates() {
        Class[] generated = new Class[]{};
        switch (this.m_returnType) {
            case Integer: {
                generated = new Class[]{Integer.class};
                break;
            }
            case IntArray: {
                generated = new Class[]{Integer[].class};
                break;
            }
            case Int2DArray: {
                generated = new Class[]{Integer[][].class};
                break;
            }
            case String: {
                generated = new Class[]{String.class};
                break;
            }
            case StrArray: {
                generated = new Class[]{String[].class};
                break;
            }
            case Str2DArray: {
                generated = new Class[]{Integer[][].class};
                break;
            }
            case Double: {
                generated = new Class[]{Double.class};
                break;
            }
            case DubArray: {
                generated = new Class[]{Double[].class};
                break;
            }
            default: {
                generated = new Class[]{Double[][].class};
            }
        }
        return generated;
    }

    protected String doExecute() {
        RServe rs = new RServe();
        this.m_returnedObject = rs.doRequest(this.m_rScript);
        return "completed, with" + (Object)((Object)this.m_returnType);
    }

    public String globalInfo() {
        return "Carries out an r command on the token passed in";
    }
}

