/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class LogTargetRegressor
extends SingleClassifierEnhancer {
    private static final long serialVersionUID = -6941274159321491218L;
    public static final double ATT_CONSTANT = 1.0;
    public static final double CLASS_CONSTANT = 1.0;

    public String globalInfo() {
        return "Takes logs of all numeric attributes in the data.";
    }

    public Instance transform(Instance inst) {
        double[] vals = inst.toDoubleArray();
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (inst.isMissing(i) || !inst.attribute(i).isNumeric()) continue;
            vals[i] = i != inst.classIndex() ? Math.log(1.0 + vals[i]) : Math.log(1.0 + vals[i]);
        }
        DenseInstance newInst = new DenseInstance(inst.weight(), vals);
        newInst.setDataset(inst.dataset());
        return newInst;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        Instances newData = new Instances(data, data.numInstances());
        for (int i = 0; i < data.numInstances(); ++i) {
            newData.add(this.transform(data.instance(i)));
        }
        if (this.getDebug()) {
            System.out.println(newData);
        }
        this.m_Classifier.buildClassifier(newData);
    }

    public double classifyInstance(Instance inst) throws Exception {
        double result = this.m_Classifier.classifyInstance(this.transform(inst));
        return Math.exp(result) - 1.0;
    }

    public String toString() {
        return this.m_Classifier.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 535 $");
    }

    public static void main(String[] argv) {
        LogTargetRegressor.runClassifier((Classifier)new LogTargetRegressor(), (String[])argv);
    }
}

