/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.calculation.Mtimes;
import org.ujmp.core.calculation.MtimesCalculation;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PFor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MtimesDenseMatrix
implements MtimesCalculation<DenseMatrix, DenseMatrix, DenseMatrix> {
    MtimesDenseMatrix() {
    }

    @Override
    public final void calc(DenseMatrix source1, DenseMatrix source2, DenseMatrix target) {
        if (source1 instanceof DenseMatrix2D && source2 instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            Mtimes.DENSEMATRIX2D.calc((DenseMatrix2D)source1, (DenseMatrix2D)source2, (DenseMatrix2D)target);
        } else {
            this.gemm(source1, source2, target);
        }
    }

    private final void gemm(final DenseMatrix A, final DenseMatrix B, final DenseMatrix C) {
        VerifyUtil.assert2D(A);
        VerifyUtil.assert2D(B);
        VerifyUtil.assert2D(C);
        final int m1RowCount = (int)A.getRowCount();
        final int m1ColumnCount = (int)A.getColumnCount();
        int m2RowCount = (int)B.getRowCount();
        int m2ColumnCount = (int)B.getColumnCount();
        VerifyUtil.assertEquals(m1ColumnCount, m2RowCount, "matrices have wrong sizes");
        VerifyUtil.assertEquals((long)m1RowCount, C.getRowCount(), "matrices have wrong sizes");
        VerifyUtil.assertEquals((long)m2ColumnCount, C.getColumnCount(), "matrices have wrong sizes");
        if (m1RowCount >= Mtimes.THRESHOLD && m1ColumnCount >= Mtimes.THRESHOLD && m2ColumnCount >= Mtimes.THRESHOLD) {
            new PFor(0, m2ColumnCount - 1, new Object[0]){

                public void step(int i) {
                    int irow = 0;
                    while (irow < m1RowCount) {
                        C.setAsDouble(0.0, irow, i);
                        ++irow;
                    }
                    int lcol = 0;
                    while (lcol < m1ColumnCount) {
                        double temp = B.getAsDouble(lcol, i);
                        if (temp != 0.0) {
                            int irow2 = 0;
                            while (irow2 < m1RowCount) {
                                C.setAsDouble(C.getAsDouble(irow2, i) + A.getAsDouble(irow2, lcol) * temp, irow2, i);
                                ++irow2;
                            }
                        }
                        ++lcol;
                    }
                }
            };
        } else {
            int i = 0;
            while (i < m2ColumnCount) {
                int irow = 0;
                while (irow < m1RowCount) {
                    C.setAsDouble(0.0, irow, i);
                    ++irow;
                }
                int lcol = 0;
                while (lcol < m1ColumnCount) {
                    double temp = B.getAsDouble(lcol, i);
                    if (temp != 0.0) {
                        int irow2 = 0;
                        while (irow2 < m1RowCount) {
                            C.setAsDouble(C.getAsDouble(irow2, i) + A.getAsDouble(irow2, lcol) * temp, irow2, i);
                            ++irow2;
                        }
                    }
                    ++lcol;
                }
                ++i;
            }
        }
    }
}

