/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.PlusScalar;
import org.ujmp.core.calculation.PlusScalarCalculation;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlusScalarDenseMatrix
implements PlusScalarCalculation<DenseMatrix, DenseMatrix> {
    PlusScalarDenseMatrix() {
    }

    @Override
    public final void calc(DenseMatrix source, BigDecimal value, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            PlusScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, value, (DenseMatrix2D)target);
        } else {
            VerifyUtil.assertSameSize((Matrix)source, (Matrix)target);
            for (long[] c : source.allCoordinates()) {
                BigDecimal svalue = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.plus(svalue, value);
                target.setAsBigDecimal(result, c);
            }
        }
    }

    @Override
    public final void calc(DenseMatrix source, double value, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            PlusScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, value, (DenseMatrix2D)target);
        } else {
            this.calc(source, new BigDecimal(value, MathUtil.getDefaultMathContext()), target);
        }
    }
}

