/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class JMFUtil {
    private static Locale locale;
    private static ListResourceBundle res;
    private static ListResourceBundle beanInfoRes;
    private static String lang;
    private static String ctry;

    public static String getString(String key) {
        if (res == null) {
            JMFUtil.setResourceBundle(null);
        }
        return res.getString(key);
    }

    public static String getLang() {
        return lang;
    }

    public static void setResourceBundle(Locale l2) {
        locale = Locale.getDefault();
        try {
            res = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.JMFConst", locale);
        }
        catch (MissingResourceException m2) {
            locale = new Locale("en", "US");
            res = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.JMFConst", locale);
            System.out.println("Locale not supported, defaulting to english-US.");
        }
        lang = locale.getLanguage();
        ctry = locale.getCountry();
    }

    public static String getBIString(String key) {
        if (beanInfoRes == null) {
            JMFUtil.setBIResourceBundle(null);
        }
        return beanInfoRes.getString(key);
    }

    public static void setBIResourceBundle(Locale l2) {
        locale = Locale.getDefault();
        try {
            beanInfoRes = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.MultiPlayerBeanInfoResources", locale);
        }
        catch (MissingResourceException m2) {
            locale = new Locale("en", "US");
            beanInfoRes = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.MultiPlayerBeanInfoResources", locale);
            System.out.println("Locale not supported, defaulting to english-US.");
        }
        lang = locale.getLanguage();
        ctry = locale.getCountry();
    }

    public static Locale getLocale(String l2) {
        if (l2 == null) {
            return Locale.getDefault();
        }
        String local = l2.trim().toUpperCase();
        if (local.compareTo("FRANCE") == 0) {
            return Locale.FRANCE;
        }
        if (local.compareTo("GERMANY") == 0) {
            return Locale.GERMANY;
        }
        if (local.compareTo("ITALY") == 0) {
            return Locale.ITALY;
        }
        if (local.compareTo("JAPAN") == 0) {
            return Locale.JAPAN;
        }
        if (local.compareTo("KOREA") == 0) {
            return Locale.KOREA;
        }
        if (local.compareTo("CHINA") == 0) {
            return Locale.CHINA;
        }
        if (local.compareTo("PRC") == 0) {
            return Locale.PRC;
        }
        if (local.compareTo("TAIWAN") == 0) {
            return Locale.TAIWAN;
        }
        if (local.compareTo("UK") == 0) {
            return Locale.UK;
        }
        if (local.compareTo("US") == 0) {
            return Locale.US;
        }
        if (local.compareTo("CANADA") == 0) {
            return Locale.CANADA;
        }
        if (local.compareTo("CANADA_FRENCH") == 0) {
            return Locale.CANADA_FRENCH;
        }
        return null;
    }

    public static Panel doGridbagLayout2(Component[] comp, int column, int stretch) {
        Panel pan = new Panel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        pan.setLayout(gb);
        pan.setBackground(Color.lightGray);
        pan.setForeground(Color.black);
        c2.insets = new Insets(1, 0, 0, 1);
        c2.anchor = 17;
        int i2 = 0;
        while (i2 < comp.length) {
            c2.gridwidth = 1;
            c2.weighty = 0.0;
            c2.weightx = 0.0;
            c2.fill = 0;
            if (i2 % column - column + 1 == 0) {
                c2.gridwidth = 0;
            }
            if (i2 % column - stretch + 1 == 0) {
                c2.fill = 2;
                c2.weighty = 1.0;
                c2.weightx = 1.0;
            }
            gb.setConstraints(comp[i2], c2);
            pan.add(comp[i2], c2);
            ++i2;
        }
        return pan;
    }

    public static void centerComponent(Panel pan, Component comp) {
        JMFUtil.doDebug("centerComponent");
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        pan.setLayout(gb);
        c2.insets = new Insets(0, 0, 0, 0);
        c2.anchor = 10;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.weighty = 0.0;
        c2.weightx = 0.0;
        c2.fill = 0;
        gb.setConstraints(comp, c2);
        pan.add(comp, c2);
    }

    public static float aspectRatio(float width, float height, int controllerHeight) {
        return width / (height - (float)controllerHeight);
    }

    public static void center(Panel parent, Component comp, boolean fit, int dheight) {
        int pwidth = parent.getSize().width;
        int pheight = parent.getSize().height;
        comp.setBounds(parent.getInsets().left, parent.getInsets().top, pwidth - parent.getInsets().left - parent.getInsets().right, pheight - parent.getInsets().top - parent.getInsets().bottom);
    }

    public static void setCenterLocation(Frame self, Frame parent, int width, int height) {
        Rectangle rect;
        JMFUtil.doDebug("setCenterLocation");
        if (parent != null) {
            rect = parent.getBounds();
        } else {
            Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
            rect = new Rectangle(new Point(0, 0), d2);
        }
        ((Component)self).setSize(width, height);
        ((Component)self).setLocation(rect.x + (rect.width - width) / 2, rect.y + (rect.height - height) / 2);
    }

    public static void copyStringArray(String[] oldArray, String[] newArray) {
        if (oldArray == null | newArray == null) {
            return;
        }
        int i2 = 0;
        while (i2 < oldArray.length) {
            newArray[i2] = oldArray[i2];
            ++i2;
        }
    }

    public static void copyShortenStringArray(String[] oldArray, String[] newArray, int index, int size) {
        if (oldArray == null | newArray == null) {
            return;
        }
        int i2 = 0;
        while (i2 < newArray.length) {
            newArray[i2] = i2 >= index ? oldArray[i2 + size] : oldArray[i2];
            ++i2;
        }
    }

    public static String parseArrayIntoString(String[] value) {
        StringBuffer property = new StringBuffer("");
        if (value != null) {
            int i2 = 0;
            while (i2 < value.length) {
                property.append(value[i2]);
                if (i2 != value.length - 1) {
                    property.append(",");
                }
                JMFUtil.doDebug(property.toString());
                ++i2;
            }
        }
        return property.toString();
    }

    public static String[] parseStringIntoArray(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return null;
        }
        String temp = value;
        String sub = "";
        String[] tempArray = null;
        int length = 0;
        Vector<String> strings = new Vector<String>();
        int index = -1;
        JMFUtil.doDebug("Value = " + value);
        index = temp.indexOf(",");
        length = temp.length();
        while (index != -1) {
            sub = temp.substring(0, index);
            strings.addElement(sub);
            if (index + 1 < length) {
                temp = temp.substring(index + 1, length);
            } else if (index + 1 == length) {
                temp = "";
                strings.addElement("");
            }
            index = temp.indexOf(",");
            length = temp.length();
        }
        if (temp != null & length != 0) {
            strings.addElement(temp.substring(0, length));
        }
        tempArray = new String[strings.size()];
        int i2 = 0;
        while (i2 < strings.size()) {
            tempArray[i2] = (String)strings.elementAt(i2);
            ++i2;
        }
        return tempArray;
    }

    public static String convertString(String s) {
        if (s == null) {
            return "";
        }
        if (s.length() == 0) {
            return s;
        }
        boolean count = false;
        int index = -1;
        StringBuffer newString = new StringBuffer(s);
        int i2 = 0;
        while (i2 < newString.length()) {
            if (newString.charAt(i2) == '\\' || newString.charAt(i2) == '\"') {
                newString.insert(i2, "\\");
                ++i2;
            }
            ++i2;
        }
        return newString.toString();
    }

    public static boolean msVersion() {
        boolean msVersion;
        try {
            Class<?> sysVerMgr = Class.forName("com.ms.util.SystemVersionManager");
            msVersion = true;
        }
        catch (Throwable e2) {
            msVersion = false;
        }
        return msVersion;
    }

    private static void doDebug(String s) {
    }

    static {
        lang = null;
        ctry = null;
    }
}

