/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sdp;

import com.sun.media.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class Parser {
    private static Vector buffer;

    public void init() {
        buffer = new Vector();
    }

    public void ungetToken(String tokenStr) {
        byte[] token = tokenStr.getBytes();
        int i2 = 0;
        while (i2 < token.length) {
            buffer.insertElementAt(new Integer(token[token.length - i2 - 1]), 0);
            ++i2;
        }
    }

    public boolean getToken(ByteArrayInputStream bin, String tokenString) {
        String token;
        boolean found = false;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.skipWhitespace(bin);
        if (bin.available() > 0) {
            int ch = this.readChar(bin);
            while (ch != 61 && ch != 10 && ch != 13 && ch != -1) {
                bout.write(ch);
                ch = this.readChar(bin);
            }
            bout.write(ch);
        }
        if (tokenString.equals(token = new String(bout.toByteArray()))) {
            found = true;
        } else {
            this.ungetToken(token);
        }
        return found;
    }

    public boolean getToken(ByteArrayInputStream bin, String tokenString, boolean mandatory) {
        boolean found = this.getToken(bin, tokenString);
        if (!found && mandatory) {
            Log.warning("[SDP Parser] Token missing: " + tokenString);
        }
        return found;
    }

    public String getLine(ByteArrayInputStream bin) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (bin.available() > 0) {
            int ch = this.readChar(bin);
            while (ch != 10 && ch != 13 && ch != -1) {
                bout.write(ch);
                ch = this.readChar(bin);
            }
        }
        String line = new String(bout.toByteArray());
        return line;
    }

    private void skipWhitespace(ByteArrayInputStream bin) {
        int ch = this.readChar(bin);
        while (ch == 32 || ch == 10 || ch == 13) {
            ch = this.readChar(bin);
        }
        buffer.insertElementAt(new Integer(ch), 0);
    }

    public int readChar(ByteArrayInputStream bin) {
        int ch;
        if (buffer.size() > 0) {
            ch = (Integer)buffer.elementAt(0);
            buffer.removeElementAt(0);
        } else {
            ch = bin.read();
        }
        return ch;
    }
}

