/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.Distribution;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.NumericStabilityException;

public class ChangeableDistribution
extends Distribution {
    private static final long serialVersionUID = 5399043391530434461L;

    public ChangeableDistribution(Alphabet alpha, boolean useLogSpace) {
        super(alpha, useLogSpace);
    }

    public void setProb(String s, double prob) throws NumericStabilityException, IllegalSymbolException {
        this.probs[this.alphabet.indexOfAlphabetSymbol((String)s)] = prob;
        this.adjust();
    }

    public void setProbWithIndex(int index, double prob) throws NumericStabilityException {
        this.probs[index] = prob;
        this.adjust();
    }

    protected void adjust() throws NumericStabilityException {
        if (!this.useLogSpace) {
            int i;
            double sum = 0.0;
            for (i = 0; i < this.probs.length; ++i) {
                sum += this.probs[i];
            }
            if (sum <= 0.0) {
                throw new NumericStabilityException("Can't normalize array. Sum is zero or smaller.");
            }
            i = 0;
            while (i < this.probs.length) {
                int n = i++;
                this.probs[n] = this.probs[n] / sum;
            }
        } else {
            int i;
            double sum = Double.NEGATIVE_INFINITY;
            for (i = 0; i < this.probs.length; ++i) {
                sum = ChangeableDistribution.logplus(sum, this.probs[i]);
            }
            if (sum == Double.NEGATIVE_INFINITY) {
                throw new NumericStabilityException("Can't normalize array. Sum is negative infinity.");
            }
            for (i = 0; i < this.probs.length; ++i) {
                this.probs[i] = this.probs[i] - sum;
            }
        }
    }

    protected static double logplus(double plog, double qlog) {
        double diff;
        double max;
        if (plog > qlog) {
            if (qlog == Double.NEGATIVE_INFINITY) {
                return plog;
            }
            max = plog;
            diff = qlog - plog;
        } else {
            if (plog == Double.NEGATIVE_INFINITY) {
                return qlog;
            }
            max = qlog;
            diff = plog - qlog;
        }
        return max + (diff < -37.0 ? 0.0 : Math.log(1.0 + Math.exp(diff)));
    }
}

