/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.ODFLoader;

public class ODFSaver
extends AbstractFileSaver
implements BatchConverter {
    private static final long serialVersionUID = -7446832500561589653L;
    protected String m_MissingValue = "";

    public ODFSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in ODF spreadsheet format.\nFor instance for spreadsheets that can be read with OpenOffice.org.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe string representing a missing value.\n\t(default: ?)", "M", 1, "-M <str>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption((char)'M', (String[])options);
        if (tmpStr.length() != 0) {
            this.setMissingValue(tmpStr);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-M");
        result.add(this.getMissingValue());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values, default is '' (empty cell).";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(ODFLoader.FILE_EXTENSION);
        this.setMissingValue("");
    }

    public String getFileDescription() {
        return ODFLoader.FILE_DESCRIPTION;
    }

    public String[] getFileExtensions() {
        return new String[]{ODFLoader.FILE_EXTENSION};
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        try {
            Instances data = this.getInstances();
            DefaultTableModel model = new DefaultTableModel(data.numInstances() + 1, data.numAttributes());
            Object[] header = new String[data.numAttributes()];
            for (int i = 0; i < data.numAttributes(); ++i) {
                header[i] = data.attribute(i).name();
            }
            model.setColumnIdentifiers(header);
            for (int n = 0; n < data.numInstances(); ++n) {
                Instance inst = data.instance(n);
                for (int i = 0; i < data.numAttributes(); ++i) {
                    if (inst.isMissing(i)) {
                        model.setValueAt(this.m_MissingValue, n, i);
                        continue;
                    }
                    if (inst.attribute(i).isNumeric()) {
                        model.setValueAt(inst.value(i), n, i);
                        continue;
                    }
                    model.setValueAt(inst.stringValue(i), n, i);
                }
            }
            SpreadSheet spreadsheet = SpreadSheet.createEmpty((TableModel)model);
            if (this.retrieveFile() == null) {
                spreadsheet.getPackage().save((OutputStream)System.out);
            } else {
                spreadsheet.saveAs(this.retrieveFile());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.setWriteMode(1);
        this.resetWriter();
        this.setWriteMode(2);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 7034 $");
    }

    public static void main(String[] args) {
        ODFSaver.runFileSaver((AbstractFileSaver)new ODFSaver(), (String[])args);
    }
}

