/*
 * Decompiled with CFR 0.152.
 */
package adams.data.sequence;

import adams.core.io.PlaceholderFile;
import adams.data.container.AbstractDataContainer;
import adams.data.container.DataPoint;
import adams.data.container.DataPointComparator;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.data.sequence.XYSequenceUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class XYSequence<X extends Number, Y extends Number>
extends AbstractDataContainer<XYSequencePoint<X, Y>> {
    private static final long serialVersionUID = -3742507986126404535L;
    public static final String FILE_EXTENSION = ".csv";
    protected DataPointComparator m_Comparator;
    protected XYSequencePointComparator.Comparison m_Comparison;

    public XYSequence() {
        this.setComparison(XYSequencePointComparator.Comparison.X);
    }

    public void setComparison(XYSequencePointComparator.Comparison value) {
        this.m_Comparison = value;
        this.m_Comparator = this.newComparator();
    }

    public XYSequencePointComparator.Comparison getComparison() {
        return this.m_Comparison;
    }

    @Override
    public DataPointComparator<XYSequencePoint<X, Y>> newComparator() {
        return new XYSequencePointComparator(this.m_Comparison, true);
    }

    @Override
    public DataPointComparator<XYSequencePoint<X, Y>> getComparator() {
        return this.m_Comparator;
    }

    @Override
    public XYSequencePoint<X, Y> newPoint() {
        return new XYSequencePoint();
    }

    public XYSequencePoint<X, Y> find(X x) {
        XYSequencePoint result = null;
        ArrayList<XYSequencePoint> points = new ArrayList<XYSequencePoint>(this.m_Points);
        int index = XYSequenceUtils.findX(points, x);
        if (index > -1) {
            result = (XYSequencePoint)this.m_Points.get(index);
        }
        return result;
    }

    public XYSequencePoint<X, Y> findClosest(X x) {
        XYSequencePoint result = null;
        ArrayList<XYSequencePoint> points = new ArrayList<XYSequencePoint>(this.m_Points);
        int index = XYSequenceUtils.findClosestX(points, x);
        if (index > -1) {
            result = (XYSequencePoint)this.m_Points.get(index);
        }
        return result;
    }

    public String getFileHeader() {
        return "ID,X,Y";
    }

    public boolean write(String filename) {
        boolean result;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new PlaceholderFile(filename).getAbsolutePath()));
            result = this.write(writer);
            writer.close();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public boolean write(BufferedWriter writer) {
        boolean result;
        try {
            writer.write(this.getFileHeader());
            writer.newLine();
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                writer.write(((XYSequencePoint)iter.next()).toString());
                writer.newLine();
            }
            writer.flush();
            result = true;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public boolean read(String filename) {
        boolean result;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            this.read(reader);
            reader.close();
            result = true;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public boolean read(BufferedReader reader) {
        boolean result;
        this.clear();
        try {
            String line;
            result = true;
            DataPoint template = this.newPoint();
            reader.readLine();
            while ((line = reader.readLine()) != null && result) {
                XYSequencePoint point = ((XYSequencePoint)template).parse(line);
                result = point != null;
                if (!result) continue;
                this.add(point);
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        XYSequence s = new XYSequence();
        s.add(new XYSequencePoint<Double, Double>("1", 1.0, 0.1));
        s.add(new XYSequencePoint<Double, Double>("2", 2.0, 0.2));
        s.add(new XYSequencePoint<Double, Double>("3", 3.0, 0.9));
        s.add(new XYSequencePoint<Double, Double>("4", 4.0, 0.5));
        s.add(new XYSequencePoint<Double, Double>("5", 5.0, 0.1));
        StringWriter writer = new StringWriter();
        s.write(new BufferedWriter(writer));
        System.out.println(writer.toString());
        StringReader reader = new StringReader(writer.toString());
        XYSequence s2 = new XYSequence();
        s2.read(new BufferedReader(reader));
        System.out.println("s == s2? " + s.equals(s2));
    }
}

