/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.db.AbstractDatabaseConnection;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;

public class DatabaseManager<T extends AbstractDatabaseConnection>
implements Serializable {
    private static final long serialVersionUID = -8832349882994980783L;
    protected String m_DatabaseName;
    protected Hashtable<String, T> m_Connections;
    protected T m_DefaultDatabaseConnection;

    public DatabaseManager(String dbName) {
        this.m_DatabaseName = dbName;
        this.m_Connections = new Hashtable();
    }

    public String getDatabaseName() {
        return this.m_DatabaseName;
    }

    protected String createURL(T dbcon) {
        return this.createURL(((AbstractDatabaseConnection)dbcon).getURL(), ((AbstractDatabaseConnection)dbcon).getUser());
    }

    protected String createURL(String url, String user) {
        return user + "@" + url;
    }

    public boolean has(String url, String user) {
        if (url == null) {
            return false;
        }
        return this.m_Connections.containsKey(this.createURL(url, user));
    }

    public T get(String url, String user) {
        if (url == null) {
            return null;
        }
        return (T)((AbstractDatabaseConnection)this.m_Connections.get(this.createURL(url, user)));
    }

    public T add(T dbcon) {
        if (dbcon == null) {
            return null;
        }
        ((AbstractDatabaseConnection)dbcon).setOwner(this);
        return (T)((AbstractDatabaseConnection)this.m_Connections.put(this.createURL(dbcon), dbcon));
    }

    public void setDefault(T value) {
        this.m_DefaultDatabaseConnection = value;
        ((AbstractDatabaseConnection)this.m_DefaultDatabaseConnection).setOwner(this);
        if (value != null) {
            this.add(value);
        }
    }

    public T getDefault() {
        return this.m_DefaultDatabaseConnection;
    }

    public Iterator<T> iterator() {
        return this.m_Connections.values().iterator();
    }

    public String toString() {
        return this.getDatabaseName() + ": " + this.m_Connections.keySet();
    }
}

