/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.id.MutableIDHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.util.HashSet;
import java.util.Hashtable;

public class UniqueID
extends AbstractTransformer {
    private static final long serialVersionUID = -5763179484838892202L;
    public static final String BACKUP_IDS = "ids";
    public static final String SEPARATOR = "#";
    protected HashSet<String> m_IDs;

    @Override
    public String globalInfo() {
        return "Ensures that all passing through tokens that implement " + MutableIDHandler.class.getName() + " have a unique ID.\n" + "All other tokens are just forwarded as is.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_IDs = new HashSet();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_IDs.clear();
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_IDS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_IDS, this.m_IDs);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_IDS)) {
            this.m_IDs = (HashSet)state.get(BACKUP_IDS);
            state.remove(BACKUP_IDS);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    protected String generateUniqueID(String id) {
        String result = id;
        int count = 1;
        while (this.m_IDs.contains(result)) {
            result = id + SEPARATOR + ++count;
        }
        this.m_IDs.add(result);
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_InputToken.getPayload() instanceof MutableIDHandler) {
            MutableIDHandler handler = (MutableIDHandler)this.m_InputToken.getPayload();
            String id = this.generateUniqueID(handler.getID());
            if (!handler.getID().equals(id)) {
                if (this.getDebugLevel() == 1) {
                    this.debug(handler.getID() + " -> " + id);
                } else if (this.getDebugLevel() > 1) {
                    this.debug(handler.getID() + " -> " + id + " for: " + handler);
                }
                handler.setID(id);
            }
            this.m_OutputToken = new Token(handler);
        } else {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }
}

