/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.PrintObject;
import adams.core.base.BasePassword;
import adams.core.base.BaseString;
import adams.core.management.Launcher;
import adams.core.management.ProcessUtils;
import adams.core.management.RestartableApplication;
import adams.core.net.InternetHelper;
import adams.core.net.ProxyHelper;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.db.AbstractDatabaseConnection;
import adams.db.AbstractIndexedTable;
import adams.db.DatabaseConnectionEstablisher;
import adams.db.DatabaseConnectionHandler;
import adams.env.Environment;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.AdditionalParameterHandler;
import adams.gui.application.ApplicationMenu;
import adams.gui.application.Child;
import adams.gui.application.ChildFrame;
import adams.gui.application.ChildWindow;
import adams.gui.application.UserMode;
import adams.gui.core.AbstractFrameWithOptionHandling;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.dialog.DatabaseConnectionsPanel;
import adams.gui.goe.AbstractEditorRegistration;
import adams.gui.scripting.ScriptingEngineHandler;
import adams.gui.scripting.ScriptingLogPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public abstract class AbstractApplicationFrame
extends AbstractFrameWithOptionHandling
implements DatabaseConnectionHandler,
DatabaseConnectionChangeListener,
DatabaseConnectionEstablisher,
RestartableApplication {
    private static final long serialVersionUID = -5800519559483605870L;
    public static final String LAYOUT_MENUBAR = "MenuBar";
    public static final String LAYOUT_MENU_PREFIX = "Menu.";
    public static final String LAYOUT_MENU_WINDOWS = "Windows";
    public static final String LAYOUT_SHORTCUT_SEPARATOR = "#";
    protected AbstractApplicationFrame m_Self;
    protected HashSet<Child> m_Children = new HashSet();
    protected JMenu m_MenuWindows;
    protected ScriptingLogPanel m_ScriptingLogPanel;
    protected AbstractDatabaseConnection m_DbConn;
    protected String m_ApplicationTitle;
    protected int m_DebugLevel;
    protected UserMode m_UserMode;
    protected boolean m_RequiresReconnect;
    protected boolean m_EnableRestart;
    protected BaseString[] m_StartUps;
    protected ApplicationMenu m_AppMenu;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("D", "debugLevel", 0, 0, null);
        this.m_OptionManager.add("title", "applicationTitle", this.getDefaultApplicationTitle());
        this.m_OptionManager.add("url", "URL", this.getDefaultURL(), false);
        this.m_OptionManager.add("user", "user", this.getDefaultUser(), false);
        this.m_OptionManager.add("password", "password", this.getDefaultPassword(), false);
        this.m_OptionManager.add("user-mode", "userMode", (Object)UserMode.BASIC);
        this.m_OptionManager.add("start-up", "startUps", new BaseString[0]);
        this.m_OptionManager.add("enable-restart", "enableRestart", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        ProxyHelper.getSingleton().initializeProxy();
        this.m_DbConn = this.getDefaultDatabaseConnection();
        this.m_DbConn.addChangeListener(this);
        this.m_RequiresReconnect = this.m_DbConn.getConnectOnStartUp();
        this.m_ScriptingLogPanel = new ScriptingLogPanel();
        this.m_AppMenu = null;
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    protected abstract String getDefaultApplicationTitle();

    protected String getDefaultURL() {
        return this.getDefaultDatabaseConnection().getDefaultURL();
    }

    protected String getDefaultUser() {
        return this.getDefaultDatabaseConnection().getDefaultUser();
    }

    protected BasePassword getDefaultPassword() {
        return this.getDefaultDatabaseConnection().getDefaultPassword();
    }

    protected void disconnect() {
        if (this.m_DbConn.isConnected()) {
            this.m_RequiresReconnect = true;
            this.m_DbConn.disconnect();
        }
    }

    public void setDebugLevel(int value) {
        this.m_DebugLevel = value;
        this.getDatabaseConnection().setDebugLevel(value);
        this.getDebugging().setEnabled(value > 0);
    }

    public int getDebugLevel() {
        return this.m_DebugLevel;
    }

    public String debugLevelTipText() {
        return "The greater the number the more additional info the scheme may output to the console (0 = off).";
    }

    protected boolean isDebugOn() {
        return this.m_DebugLevel > 0;
    }

    protected void debug(String msg) {
        this.debug(msg, 1);
    }

    protected void debug(String msg, int level) {
        if (level <= this.m_DebugLevel) {
            this.getDebugging().println(msg);
        }
    }

    public String getApplicationTitle() {
        return this.m_ApplicationTitle;
    }

    public void setApplicationTitle(String value) {
        this.m_ApplicationTitle = value;
        this.createTitle("");
    }

    public String applicationTitleTipText() {
        return "The title for the application.";
    }

    public String getURL() {
        return this.m_DbConn.getURL();
    }

    public void setURL(String value) {
        if (!value.equals(this.getURL())) {
            this.disconnect();
            this.m_DbConn.setURL(value);
        }
    }

    public String URLTipText() {
        return this.m_DbConn.URLTipText();
    }

    public String getUser() {
        return this.m_DbConn.getUser();
    }

    public void setUser(String value) {
        if (!value.equals(this.getUser())) {
            this.disconnect();
            this.m_DbConn.setUser(value);
        }
    }

    public String userTipText() {
        return this.m_DbConn.userTipText();
    }

    public BasePassword getPassword() {
        return this.m_DbConn.getPassword();
    }

    public void setPassword(BasePassword value) {
        if (!value.equals(this.getPassword())) {
            this.disconnect();
            this.m_DbConn.setPassword(value);
        }
    }

    public String passwordTipText() {
        return this.m_DbConn.passwordTipText();
    }

    public void setUserMode(UserMode value) {
        if (this.m_UserMode != value) {
            this.m_UserMode = value;
            this.setJMenuBar(this.createMenuBar());
        }
    }

    public UserMode getUserMode() {
        return this.m_UserMode;
    }

    public String userModeTipText() {
        return "The user mode, which determines the visibility of the menu items.";
    }

    public BaseString[] getStartUps() {
        return this.m_StartUps;
    }

    public void setStartUps(BaseString[] value) {
        this.m_StartUps = value;
    }

    public String startUpsTipText() {
        return "The menu items to start up immediately; each consists of classname and optional parameters (in case the menu definition implements " + AdditionalParameterHandler.class.getName() + ").";
    }

    @Override
    public void setEnableRestart(boolean value) {
        if (value != this.m_EnableRestart) {
            this.m_EnableRestart = value;
            this.reset();
            this.setJMenuBar(this.createMenuBar());
        }
    }

    @Override
    public boolean getEnableRestart() {
        return this.m_EnableRestart;
    }

    @Override
    public String enableRestartTipText() {
        return "If enabled and started through the " + Launcher.class.getName() + " class, the application can be restarted through the menu.";
    }

    @Override
    public PrintObject getDebugging() {
        return super.getDebugging();
    }

    @Override
    public PrintObject getSystemOut() {
        return super.getSystemOut();
    }

    @Override
    public PrintObject getSystemErr() {
        return super.getSystemErr();
    }

    protected void setLookAndFeel() {
        GUIHelper.setLookAndFeel(GUIHelper.getLookAndFeel());
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_Self = this;
        this.setLookAndFeel();
        this.createTitle("");
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.createMenuBar());
        this.pack();
        this.setSize(this.getGraphicsConfiguration().getBounds().width, this.getHeight());
        this.setLocation(0, 0);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.reconnectIfRequired();
        new DatabaseConnectionsPanel();
        this.createTitle("");
        AbstractEditorRegistration.registerEditors();
    }

    protected void closeChildren() {
        Iterator<Child> iter = this.getWindowList();
        Vector<Child> list = new Vector<Child>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Child c = (Child)list.get(i);
            c.dispose();
        }
    }

    protected void closeApplication() {
        this.m_Self.dispose();
    }

    public void close() {
        this.closeChildren();
        this.closeApplication();
        System.exit(0);
    }

    protected abstract String getMenuLayoutFile();

    protected synchronized ApplicationMenu getAppMenu() {
        if (this.m_AppMenu == null) {
            this.m_AppMenu = new ApplicationMenu(this);
            this.m_AppMenu.setSetup(this.getMenuLayoutFile());
            this.m_AppMenu.setUserMode(this.getUserMode());
        }
        return this.m_AppMenu;
    }

    protected JMenuBar createMenuBar() {
        this.m_AppMenu = null;
        JMenuBar result = this.getAppMenu().getMenuBar();
        this.m_MenuWindows = this.getAppMenu().getWindowsMenu();
        return result;
    }

    protected ChildFrame createChildFrame(String title, Component c, int width, int height, String icon) {
        ChildFrame result = new ChildFrame(this, title, icon);
        result.setLayout(new BorderLayout());
        if (c != null) {
            result.getContentPane().add(c, "Center");
        }
        result.pack();
        if (width > -1 && height > -1) {
            result.setSize(width, height);
        }
        result.validate();
        int screenHeight = this.getGraphicsConfiguration().getBounds().height;
        int screenWidth = this.getGraphicsConfiguration().getBounds().width;
        result.setLocation((screenWidth - result.getBounds().width) / 2, (screenHeight - result.getBounds().height) / 2);
        if (c != null) {
            GUIHelper.setSizeAndLocation(result, c);
        }
        result.addDisposeWindowListener();
        if (c != null && c instanceof MenuBarProvider) {
            result.setJMenuBar(((MenuBarProvider)((Object)c)).getMenuBar());
        }
        if (c != null && c instanceof ScriptingEngineHandler && c instanceof BasePanel) {
            ScriptingEngineHandler handler = (ScriptingEngineHandler)((Object)c);
            if (GUIHelper.getStartupScript(c) != null) {
                handler.getScriptingEngine().add((BasePanel)c, GUIHelper.getStartupScript(c));
            }
        }
        result.setVisible(true);
        return result;
    }

    protected ChildWindow createChildWindow(String title, Component c, int width, int height, String icon) {
        ChildWindow result = new ChildWindow(this, title, icon);
        result.setLayout(new BorderLayout());
        if (c != null) {
            result.getContentPane().add(c, "Center");
            if (this instanceof DatabaseConnectionHandler && c instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)((Object)c)).setDatabaseConnection(this.getDatabaseConnection());
            }
        }
        result.pack();
        if (width > -1 && height > -1) {
            result.setSize(width, height);
        }
        result.validate();
        int screenHeight = this.getGraphicsConfiguration().getBounds().height;
        int screenWidth = this.getGraphicsConfiguration().getBounds().width;
        result.setLocation((screenWidth - result.getBounds().width) / 2, (screenHeight - result.getBounds().height) / 2);
        if (c != null) {
            GUIHelper.setSizeAndLocation(result, c);
        }
        result.addDisposeWindowListener();
        if (c != null && c instanceof ScriptingEngineHandler && c instanceof BasePanel) {
            ScriptingEngineHandler handler = (ScriptingEngineHandler)((Object)c);
            if (GUIHelper.getStartupScript(c) != null) {
                handler.getScriptingEngine().add((BasePanel)c, GUIHelper.getStartupScript(c));
            }
        }
        result.setVisible(true);
        return result;
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem) {
        this.insertMenuItem(menu, menuitem, 0);
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem, int startIndex) {
        boolean inserted = false;
        String newStr = menuitem.getText().toLowerCase();
        for (int i = startIndex; i < menu.getMenuComponentCount(); ++i) {
            JMenuItem current;
            String currentStr;
            if (!(menu.getMenuComponent(i) instanceof JMenuItem) || (currentStr = (current = (JMenuItem)menu.getMenuComponent(i)).getText().toLowerCase()).compareTo(newStr) <= 0) continue;
            inserted = true;
            menu.insert(menuitem, i);
            break;
        }
        if (!inserted) {
            menu.add(menuitem);
        }
    }

    public void createTitle(String title) {
        HashSet<AbstractDatabaseConnection> conns;
        String newTitle = this.getApplicationTitle();
        String name = InternetHelper.getLocalHostName();
        if (name != null) {
            newTitle = newTitle + "@" + name;
        }
        if ((conns = AbstractDatabaseConnection.getActiveConnectionObjects()).size() > 0) {
            HashSet<String> connsStr = new HashSet<String>();
            for (AbstractDatabaseConnection conn : conns) {
                connsStr.add(conn.toStringShort());
            }
            Vector connsList = new Vector(connsStr);
            Collections.sort(connsList);
            newTitle = newTitle + " " + connsList;
        } else {
            newTitle = newTitle + " [-not connected-]";
        }
        if (title.length() != 0) {
            newTitle = title.length() > 50 ? newTitle + " - " + title.substring(0, 50) + "..." : newTitle + " - " + title;
        }
        this.setTitle(newTitle);
    }

    public void addChildFrame(ChildFrame c) {
        this.m_Children.add(c);
        this.windowListChanged();
    }

    public void addChildWindow(ChildWindow c) {
        this.m_Children.add(c);
        this.windowListChanged();
    }

    public boolean removeChildFrame(Container c) {
        boolean result = this.m_Children.remove(c);
        this.windowListChanged();
        return result;
    }

    public boolean showWindow(Child c) {
        boolean result = false;
        if (c != null) {
            this.createTitle(c.getTitle());
            if (c instanceof ChildFrame) {
                ((ChildFrame)c).setExtendedState(0);
            }
            c.toFront();
            c.requestFocus();
            result = true;
        }
        return result;
    }

    public boolean showWindow(Class windowClass) {
        return this.showWindow(this.getWindow(windowClass));
    }

    public Iterator<Child> getWindowList() {
        return this.m_Children.iterator();
    }

    public Child getWindow(Class windowClass) {
        Child result = null;
        Iterator<Child> iter = this.getWindowList();
        while (iter.hasNext()) {
            Child current = iter.next();
            if (current.getClass() != windowClass) continue;
            result = current;
            break;
        }
        return result;
    }

    public Child getWindow(String title) {
        Child result = null;
        Iterator<Child> iter = this.getWindowList();
        while (iter.hasNext()) {
            Child current = iter.next();
            boolean found = current.getTitle().equals(title);
            if (!found) continue;
            result = current;
            break;
        }
        return result;
    }

    public boolean containsWindow(Class windowClass) {
        return this.getWindow(windowClass) != null;
    }

    public boolean containsWindow(String title) {
        return this.getWindow(title) != null;
    }

    public void minimizeWindows() {
        Iterator<Child> iter = this.getWindowList();
        while (iter.hasNext()) {
            Child child = iter.next();
            try {
                if (!(child instanceof ChildFrame)) continue;
                ((ChildFrame)child).setExtendedState(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void restoreWindows() {
        Iterator<Child> iter = this.getWindowList();
        while (iter.hasNext()) {
            Child child = iter.next();
            try {
                if (!(child instanceof ChildFrame)) continue;
                ((ChildFrame)child).setExtendedState(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void windowListChanged() {
        this.buildWindowsMenu();
    }

    protected synchronized void buildWindowsMenu() {
        this.m_MenuWindows.removeAll();
        JMenuItem menuitem = new JMenuItem("Minimize");
        menuitem.setIcon(GUIHelper.getIcon("minimize.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractApplicationFrame.this.minimizeWindows();
            }
        });
        this.m_MenuWindows.add(menuitem);
        menuitem = new JMenuItem("Restore");
        menuitem.setIcon(GUIHelper.getIcon("maximize.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractApplicationFrame.this.restoreWindows();
            }
        });
        this.m_MenuWindows.add(menuitem);
        this.m_MenuWindows.addSeparator();
        int startIndex = this.m_MenuWindows.getMenuComponentCount() - 1;
        Iterator<Child> iter = this.getWindowList();
        this.m_MenuWindows.setVisible(iter.hasNext());
        while (iter.hasNext()) {
            List<Image> images;
            Child child = iter.next();
            menuitem = new JMenuItem(child.getTitle());
            boolean useEmpty = true;
            if (child instanceof Window && (images = ((Window)((Object)child)).getIconImages()).size() > 0) {
                useEmpty = false;
                menuitem.setIcon(new ImageIcon(images.get(0)));
            }
            if (useEmpty) {
                menuitem.setIcon(GUIHelper.getEmptyIcon());
            }
            this.insertMenuItem(this.m_MenuWindows, menuitem, startIndex);
            menuitem.setActionCommand(Integer.toString(child.hashCode()));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Iterator<Child> iter = AbstractApplicationFrame.this.getWindowList();
                    while (iter.hasNext()) {
                        Child child = iter.next();
                        String hashFrame = Integer.toString(child.hashCode());
                        if (!hashFrame.equals(evt.getActionCommand())) continue;
                        AbstractApplicationFrame.this.showWindow(child);
                        break;
                    }
                }
            });
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.repaint();
        }
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DbConn;
    }

    @Override
    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DbConn = value;
    }

    @Override
    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
        this.createTitle("");
        if (e.getType() == DatabaseConnectionChangeEvent.Type.CONNECT) {
            this.m_DbConn = e.getDatabaseConnection();
        }
    }

    protected void reconnectIfRequired() {
        if (this.m_RequiresReconnect) {
            this.m_RequiresReconnect = false;
            try {
                this.m_DbConn.connect();
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to reconnect to database:");
                this.getSystemErr().printStackTrace(e);
            }
        }
    }

    @Override
    public void establishDatabaseConnection() {
        this.reconnectIfRequired();
    }

    protected void startUpMenuItems() {
        final Vector<AbstractMenuItemDefinition> items = new Vector<AbstractMenuItemDefinition>();
        for (int i = 0; i < this.m_StartUps.length; ++i) {
            AbstractMenuItemDefinition item = AbstractMenuItemDefinition.forCommandLine(this, this.m_StartUps[i].toString());
            if (this.getAppMenu().isBlacklisted(item.getClass())) {
                this.getSystemErr().println(item.getClass() + " is blacklisted and cannot be displayed!");
                continue;
            }
            if (this.getUserMode().compareTo(item.getUserMode()) < 0) {
                this.getSystemErr().println(item.getClass() + " requires at least user mode '" + (Object)((Object)this.getAppMenu().getUserMode()) + "' (current: '" + (Object)((Object)this.getUserMode()) + "')!");
                continue;
            }
            items.add(item);
        }
        if (items.size() > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < items.size(); ++i) {
                        ((AbstractMenuItemDefinition)items.get(i)).launch();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public ScriptingLogPanel getScriptingLogPanel() {
        return this.m_ScriptingLogPanel;
    }

    public static AbstractApplicationFrame runApplication(Class env, Class app, String[] options) {
        AbstractApplicationFrame result;
        Environment.setEnvironmentClass(env);
        try {
            if (OptionUtils.helpRequested(options)) {
                System.out.println("Help requested...\n");
                result = AbstractApplicationFrame.forName(app.getName(), new String[0]);
                System.out.println("\n" + OptionUtils.list(result));
                result.dispose();
                result = null;
            } else {
                result = AbstractApplicationFrame.forName(app.getName(), options);
                Environment.getInstance().setApplicationFrame(result);
                if (result.getDatabaseConnection().isConnected()) {
                    AbstractIndexedTable.initTables(result.getDatabaseConnection());
                }
                result.getSystemOut().println("PID: " + ProcessUtils.getVirtualMachinePID());
                result.setVisible(true);
                result.startUpMenuItems();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractApplicationFrame forName(String classname, String[] options) {
        AbstractApplicationFrame result;
        try {
            result = (AbstractApplicationFrame)OptionUtils.forName(AbstractApplicationFrame.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractApplicationFrame forCommandLine(String cmdline) {
        return (AbstractApplicationFrame)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

