/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.annotation.MixedCopyright;
import adams.env.Environment;
import adams.gui.chooser.FontChooser;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@MixedCopyright(author="Ian Darwin", copyright="1996-2002 Ian F. Darwin, http://www.darwinsys.com/", license="BSD (2-clause)", url="http://www.java2s.com/Code/Java/Tiny-Application/Afontselectiondialog.htm")
public class FontChooserPanel
extends BasePanel {
    private static final long serialVersionUID = 4228582248866956387L;
    public static final Integer[] FONT_SIZES = new Integer[]{8, 10, 11, 12, 14, 16, 18, 20, 24, 30, 36, 40, 48, 60, 72};
    public static final String DEFAULT_FONT = "Serif";
    public static final Integer DEFAULT_SIZE = 12;
    protected Font m_Current;
    protected JList m_ListFontName;
    protected DefaultListModel m_ModelFontName;
    protected JList m_ListFontSize;
    protected JCheckBox m_CheckBoxBold;
    protected JCheckBox m_CheckBoxItalic;
    protected JTextArea m_TextSample;
    protected boolean m_IgnoreUpdates;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panelFonts = new JPanel(new BorderLayout(5, 5));
        panelFonts.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.add((Component)panelFonts, "North");
        this.m_ModelFontName = new DefaultListModel();
        for (String name : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this.m_ModelFontName.addElement(name);
        }
        this.m_ListFontName = new JList(this.m_ModelFontName);
        this.m_ListFontName.setSelectionMode(0);
        this.m_ListFontName.setSelectedIndex(0);
        this.m_ListFontName.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FontChooserPanel.this.m_IgnoreUpdates) {
                    return;
                }
                FontChooserPanel.this.previewFont();
            }
        });
        panelFonts.add((Component)new BaseScrollPane(this.m_ListFontName), "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panelFonts.add((Component)panel, "East");
        JPanel panelSize = new JPanel(new BorderLayout());
        panel.add((Component)panelSize, "West");
        this.m_ListFontSize = new JList<Integer>(FONT_SIZES);
        this.m_ListFontSize.setSelectionMode(0);
        this.m_ListFontSize.setSelectedValue(DEFAULT_SIZE, true);
        this.m_ListFontSize.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FontChooserPanel.this.m_IgnoreUpdates) {
                    return;
                }
                FontChooserPanel.this.previewFont();
            }
        });
        BaseScrollPane scrollPane = new BaseScrollPane(this.m_ListFontSize);
        scrollPane.setPreferredSize(new Dimension(50, 0));
        panelSize.add(scrollPane);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel.add((Component)panel2, "Center");
        this.m_CheckBoxBold = new JCheckBox("Bold", false);
        this.m_CheckBoxBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FontChooserPanel.this.m_IgnoreUpdates) {
                    return;
                }
                FontChooserPanel.this.previewFont();
            }
        });
        this.m_CheckBoxItalic = new JCheckBox("Italic", false);
        this.m_CheckBoxItalic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FontChooserPanel.this.m_IgnoreUpdates) {
                    return;
                }
                FontChooserPanel.this.previewFont();
            }
        });
        JPanel panel3 = new JPanel(new BorderLayout());
        panel2.add((Component)panel3, "West");
        JPanel panelAttributes = new JPanel(new GridLayout(0, 1));
        panel3.add((Component)panelAttributes, "North");
        panelAttributes.add(this.m_CheckBoxBold);
        panelAttributes.add(this.m_CheckBoxItalic);
        this.m_TextSample = new JTextArea("The quick brown fox jumps over the lazy dog.");
        this.m_TextSample.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.m_TextSample.setColumns(30);
        this.m_TextSample.setRows(5);
        this.m_TextSample.setLineWrap(true);
        this.m_TextSample.setWrapStyleWord(true);
        this.m_TextSample.setEditable(false);
        this.add((Component)new BaseScrollPane(this.m_TextSample), "Center");
        this.previewFont();
    }

    protected Font createFont() {
        int attrs;
        String name = (String)this.m_ListFontName.getSelectedValue();
        int size = (Integer)this.m_ListFontSize.getSelectedValue();
        int n = attrs = this.m_CheckBoxBold.isSelected() ? 1 : 0;
        if (this.m_CheckBoxItalic.isSelected()) {
            attrs |= 2;
        }
        return new Font(name, attrs, size);
    }

    protected void previewFont() {
        this.m_Current = this.createFont();
        this.m_TextSample.setFont(this.m_Current);
    }

    public void setCurrent(Font value) {
        int index;
        this.m_IgnoreUpdates = true;
        if (value == null) {
            value = new Font(DEFAULT_FONT, 0, DEFAULT_SIZE);
        }
        if ((index = this.m_ModelFontName.indexOf(value.getName())) == -1) {
            index = this.m_ModelFontName.indexOf(value.getFamily());
        }
        if (index == -1) {
            this.m_ListFontName.setSelectedValue(DEFAULT_FONT, true);
        } else {
            this.m_ListFontName.setSelectedIndex(index);
        }
        this.m_ListFontName.ensureIndexIsVisible(this.m_ListFontName.getSelectedIndex());
        this.m_ListFontSize.setSelectedValue(value.getSize(), true);
        if (this.m_ListFontSize.getSelectedIndex() == -1) {
            this.m_ListFontSize.setSelectedValue(DEFAULT_SIZE, true);
        }
        this.m_CheckBoxBold.setSelected(value.isBold());
        this.m_CheckBoxItalic.setSelected(value.isItalic());
        this.m_IgnoreUpdates = false;
        this.previewFont();
    }

    public Font getCurrent() {
        return this.m_Current;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        final BaseFrame frame = new BaseFrame("FontChooser Startup");
        final FontChooser chooser = new FontChooser(frame);
        chooser.setCurrent(null);
        frame.getContentPane().setLayout(new GridLayout(0, 1));
        JButton button = new JButton("Change font");
        frame.getContentPane().add(button);
        final JLabel label = new JLabel("Java is great!", 0);
        label.setFont(chooser.getCurrent());
        frame.getContentPane().add(label);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooser.setVisible(true);
                Font myNewFont = chooser.getCurrent();
                System.out.println("You chose " + myNewFont);
                label.setFont(myNewFont);
                frame.pack();
                chooser.dispose();
            }
        });
        frame.setSize(150, 100);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

