/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.PrintObject;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.env.HomeRelocator;
import adams.gui.core.BaseFrame;

public abstract class AbstractFrameWithOptionHandling
extends BaseFrame
implements OptionHandler,
HomeRelocator {
    private static final long serialVersionUID = -5800519559483605870L;
    protected OptionManager m_OptionManager;
    protected String m_Home;

    public AbstractFrameWithOptionHandling() {
        this("");
    }

    public AbstractFrameWithOptionHandling(String title) {
        super(title);
    }

    @Override
    protected void performInitialization() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
        this.initGUI();
        this.finishInit();
    }

    protected OptionManager newOptionManager() {
        return new OptionManager(this);
    }

    @Override
    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
        this.m_OptionManager.add("home", "home", "");
    }

    protected void reset() {
    }

    @Override
    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    @Override
    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    @Override
    public void destroy() {
        this.cleanUpOptions();
    }

    protected PrintObject getDebugging() {
        return this.m_Debugging;
    }

    protected PrintObject getSystemOut() {
        return this.m_SystemOut;
    }

    protected PrintObject getSystemErr() {
        return this.m_SystemErr;
    }

    @Override
    public void setHome(String value) {
        this.m_Home = value;
        this.reset();
    }

    @Override
    public String getHome() {
        return this.m_Home;
    }

    public String homeTipText() {
        return "The directory to use as the project's home directory, overriding the automatically determined one.";
    }

    public static AbstractFrameWithOptionHandling forName(String classname, String[] options) {
        AbstractFrameWithOptionHandling result;
        try {
            result = (AbstractFrameWithOptionHandling)OptionUtils.forName(AbstractFrameWithOptionHandling.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractFrameWithOptionHandling runFrame(Class env, Class app, String[] options) {
        AbstractFrameWithOptionHandling result;
        Environment.setEnvironmentClass(env);
        Environment.setHome(OptionUtils.getOption(options, "-home"));
        try {
            if (OptionUtils.helpRequested(options)) {
                System.out.println("Help requested...\n");
                result = AbstractFrameWithOptionHandling.forName(app.getName(), new String[0]);
                System.out.println("\n" + OptionUtils.list(result));
                result.dispose();
                result = null;
            } else {
                result = AbstractFrameWithOptionHandling.forName(app.getName(), options);
                result.setVisible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }
}

