/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.option.AbstractOptionProducer;
import adams.core.option.NestedProducer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.gui.core.BaseDialog;
import adams.gui.core.GUIHelper;
import adams.gui.core.TextEditorPanel;
import adams.gui.goe.AbstractGenericObjectEditorHandler;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GenericObjectEditorPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -5216584001020734521L;
    protected HashSet<ChangeListener> m_ChangeListeners = new HashSet();

    public GenericObjectEditorPopupMenu(final PropertyEditor editor, final JComponent comp) {
        JMenuItem item = null;
        boolean hasNested = editor.getValue() instanceof OptionHandler;
        final boolean customStringRepresentation = editor instanceof CustomStringRepresentationHandler;
        final String itemText = customStringRepresentation ? "string representation" : "setup";
        if (hasNested) {
            item = new JMenuItem("Copy nested setup", GUIHelper.getIcon("copy.gif"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIHelper.copyToClipboard(AbstractOptionProducer.toString(NestedProducer.class, (OptionHandler)editor.getValue()));
                }
            });
            this.add(item);
        }
        item = customStringRepresentation ? new JMenuItem("Copy " + itemText, GUIHelper.getEmptyIcon()) : new JMenuItem("Copy command-line setup", GUIHelper.getEmptyIcon());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (customStringRepresentation) {
                    GUIHelper.copyToClipboard(((CustomStringRepresentationHandler)((Object)editor)).toCustomStringRepresentation(editor.getValue()));
                } else {
                    GUIHelper.copyToClipboard(OptionUtils.getCommandLine(editor.getValue()));
                }
            }
        });
        this.add(item);
        if (this.getCanChangeClassInDialog(editor) || customStringRepresentation) {
            item = new JMenuItem("Paste " + itemText, GUIHelper.getIcon("paste.gif"));
            item.setEnabled(GUIHelper.canPasteFromClipboard());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String str = GUIHelper.pasteSetupFromClipboard();
                    try {
                        if (customStringRepresentation) {
                            editor.setValue(((CustomStringRepresentationHandler)((Object)editor)).fromCustomStringRepresentation(str));
                        } else {
                            editor.setValue(OptionUtils.forString(Object.class, str));
                        }
                        GenericObjectEditorPopupMenu.this.notifyChangeListeners();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        GUIHelper.showErrorMessage(comp, "Error processing " + itemText + " from clipboard:\n" + ex);
                    }
                }
            });
            this.add(item);
            item = new JMenuItem("Enter " + itemText + "...", GUIHelper.getIcon("input.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final BaseDialog dlg = GUIHelper.getParentDialog(comp) != null ? new BaseDialog(GUIHelper.getParentDialog(comp), Dialog.ModalityType.DOCUMENT_MODAL) : new BaseDialog(GUIHelper.getParentFrame(comp), true);
                    dlg.setTitle("Enter " + itemText);
                    dlg.getContentPane().setLayout(new BorderLayout());
                    final TextEditorPanel textpanel = new TextEditorPanel();
                    dlg.getContentPane().add((Component)textpanel, "Center");
                    JButton buttonOK = new JButton("OK");
                    buttonOK.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dlg.setVisible(false);
                            try {
                                if (customStringRepresentation) {
                                    editor.setValue(((CustomStringRepresentationHandler)((Object)editor)).fromCustomStringRepresentation(textpanel.getContent()));
                                } else {
                                    editor.setValue(OptionUtils.forString(Object.class, textpanel.getContent()));
                                }
                                GenericObjectEditorPopupMenu.this.notifyChangeListeners();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                GUIHelper.showErrorMessage(comp, "Error parsing " + itemText + ":\n" + ex);
                            }
                        }
                    });
                    JButton buttonCancel = new JButton("Cancel");
                    buttonCancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dlg.setVisible(false);
                        }
                    });
                    JPanel panel = new JPanel(new FlowLayout(2));
                    panel.add(buttonOK);
                    panel.add(buttonCancel);
                    dlg.getContentPane().add((Component)panel, "South");
                    dlg.pack();
                    dlg.setSize(400, 300);
                    dlg.setLocationRelativeTo(comp);
                    dlg.setVisible(true);
                }
            });
            this.add(item);
        }
    }

    protected boolean getCanChangeClassInDialog(PropertyEditor editor) {
        AbstractGenericObjectEditorHandler handler = AbstractGenericObjectEditorHandler.getHandler(editor);
        return handler.getCanChangeClassInDialog(editor);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(e);
        }
    }
}

