/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.flow.sink.AbstractFileWriter;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;

public class MovieWriter
extends AbstractFileWriter
implements ControllerListener,
DataSinkListener {
    private static final long serialVersionUID = 7509908838736709270L;
    protected int m_Width;
    protected int m_Height;
    protected int m_FrameRate;
    protected transient Object m_WaitSync;
    protected boolean m_StateTransitionOK;
    protected transient Object m_WaitFileSync;
    protected boolean m_FileDone;
    protected boolean m_FileSuccess;

    public String globalInfo() {
        return "Actor for turning JPEG images into Quicktime movies.\n\nOriginal code taken from Sun's JpegImagesToMovie.java example:\nhttp://www.koders.com/java/fid8AE9208DC5FB846910DFD3F935D64E7C9A5BB784.aspx";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("height", "height", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("frame-rate", "frameRate", (Object)-1, (Number)-1, null);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("width");
        String result = variable != null ? variable : "" + this.m_Width;
        result = result + " x ";
        variable = this.getOptionManager().getVariableForProperty("height");
        result = variable != null ? result + variable : result + "" + this.m_Height;
        result = result + " @ ";
        variable = this.getOptionManager().getVariableForProperty("frameRate");
        result = variable != null ? result + variable : result + "" + this.m_FrameRate;
        return result;
    }

    public String outputFileTipText() {
        return "The filename of the image to write.";
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The screen width of the movie.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The screen height of the movie.";
    }

    public void setFrameRate(int value) {
        this.m_FrameRate = value;
        this.reset();
    }

    public int getFrameRate() {
        return this.m_FrameRate;
    }

    public String frameRateTipText() {
        return "The frame rate of the movie.";
    }

    public Class[] accepts() {
        return new Class[]{String[].class, File[].class};
    }

    protected String create(MediaLocator outML, Vector<String> inFiles) {
        Processor p;
        ImageDataSource ids = new ImageDataSource(this.m_Width, this.m_Height, this.m_FrameRate, inFiles);
        try {
            p = Manager.createProcessor((DataSource)ids);
        }
        catch (Exception e) {
            return "Cannot create a processor from the data source.";
        }
        p.addControllerListener((ControllerListener)this);
        p.configure();
        if (!this.waitForState(p, 180)) {
            return "Failed to configure the processor.";
        }
        p.setContentDescriptor(new ContentDescriptor("video.quicktime"));
        TrackControl[] tcs = p.getTrackControls();
        Format[] f = tcs[0].getSupportedFormats();
        if (f == null || f.length <= 0) {
            return "The mux does not support the input format: " + tcs[0].getFormat();
        }
        tcs[0].setFormat(f[0]);
        p.realize();
        if (!this.waitForState(p, 300)) {
            return "Failed to realize the processor.";
        }
        DataSink dsink = this.createDataSink(p, outML);
        if (dsink == null) {
            return "Failed to create a DataSink for the given output MediaLocator: " + outML;
        }
        dsink.addDataSinkListener((DataSinkListener)this);
        this.m_FileDone = false;
        try {
            p.start();
            dsink.start();
        }
        catch (IOException e) {
            return "IO error during processing";
        }
        this.waitForFileDone();
        try {
            dsink.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        p.removeControllerListener((ControllerListener)this);
        return null;
    }

    protected DataSink createDataSink(Processor p, MediaLocator outML) {
        DataSink dsink;
        DataSource ds = p.getDataOutput();
        if (ds == null) {
            this.getSystemErr().println("Something is really wrong: the processor does not have an output DataSource");
            return null;
        }
        try {
            dsink = Manager.createDataSink((DataSource)ds, (MediaLocator)outML);
            dsink.open();
        }
        catch (Exception e) {
            this.getSystemErr().println("Cannot create the DataSink: " + e);
            return null;
        }
        return dsink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForState(Processor p, int state) {
        Object object = this.m_WaitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.m_StateTransitionOK) {
                    this.m_WaitSync.wait();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.m_StateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.m_WaitSync;
            synchronized (object) {
                this.m_StateTransitionOK = true;
                this.m_WaitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.m_WaitSync;
            synchronized (object) {
                this.m_StateTransitionOK = false;
                this.m_WaitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().stop();
            evt.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFileDone() {
        Object object = this.m_WaitFileSync;
        synchronized (object) {
            try {
                while (!this.m_FileDone) {
                    this.m_WaitFileSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_FileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.m_WaitFileSync;
            synchronized (object) {
                this.m_FileDone = true;
                this.m_WaitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.m_WaitFileSync;
            synchronized (object) {
                this.m_FileDone = true;
                this.m_FileSuccess = false;
                this.m_WaitFileSync.notifyAll();
            }
        }
    }

    protected String doExecute() {
        String result = null;
        this.m_WaitSync = new Object();
        this.m_WaitFileSync = new Object();
        this.m_StateTransitionOK = true;
        this.m_FileDone = false;
        this.m_FileSuccess = true;
        if (result == null) {
            MediaLocator locator = new MediaLocator("file:" + this.m_OutputFile.getAbsolutePath());
            Vector<String> files = new Vector<String>();
            if (this.m_InputToken.getPayload() instanceof File[]) {
                File[] fileFiles;
                for (File file : fileFiles = (File[])this.m_InputToken.getPayload()) {
                    files.add(file.getAbsolutePath());
                }
            } else {
                String[] strFiles;
                for (String file : strFiles = (String[])this.m_InputToken.getPayload()) {
                    files.add(new PlaceholderFile(file).getAbsolutePath());
                }
            }
            result = this.create(locator, files);
        }
        return result;
    }

    class ImageSourceStream
    implements PullBufferStream {
        Vector images;
        int width;
        int height;
        VideoFormat format;
        int nextImage = 0;
        boolean ended = false;

        public ImageSourceStream(int width, int height, int frameRate, Vector images) {
            this.width = width;
            this.height = height;
            this.images = images;
            this.format = new VideoFormat("jpeg", new Dimension(width, height), -1, Format.byteArray, (float)frameRate);
        }

        public boolean willReadBlock() {
            return false;
        }

        public void read(Buffer buf) throws IOException {
            if (this.nextImage >= this.images.size()) {
                buf.setEOM(true);
                buf.setOffset(0);
                buf.setLength(0);
                this.ended = true;
                return;
            }
            String imageFile = (String)this.images.elementAt(this.nextImage);
            ++this.nextImage;
            RandomAccessFile raFile = new RandomAccessFile(imageFile, "r");
            byte[] data = null;
            if (buf.getData() instanceof byte[]) {
                data = (byte[])buf.getData();
            }
            if (data == null || (long)data.length < raFile.length()) {
                data = new byte[(int)raFile.length()];
                buf.setData((Object)data);
            }
            raFile.readFully(data, 0, (int)raFile.length());
            buf.setOffset(0);
            buf.setLength((int)raFile.length());
            buf.setFormat((Format)this.format);
            buf.setFlags(buf.getFlags() | 0x10);
            raFile.close();
        }

        public Format getFormat() {
            return this.format;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor("raw");
        }

        public long getContentLength() {
            return 0L;
        }

        public boolean endOfStream() {
            return this.ended;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }
    }

    class ImageDataSource
    extends PullBufferDataSource {
        ImageSourceStream[] streams = new ImageSourceStream[1];

        ImageDataSource(int width, int height, int frameRate, Vector images) {
            this.streams[0] = new ImageSourceStream(width, height, frameRate, images);
        }

        public void setLocator(MediaLocator source) {
        }

        public MediaLocator getLocator() {
            return null;
        }

        public String getContentType() {
            return "raw";
        }

        public void connect() {
        }

        public void disconnect() {
        }

        public void start() {
        }

        public void stop() {
        }

        public PullBufferStream[] getStreams() {
            return this.streams;
        }

        public Time getDuration() {
            return DURATION_UNKNOWN;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }
    }
}

