/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import moa.classifiers.HoeffdingTree;
import moa.classifiers.LimAttHoeffdingTreeNB;
import moa.classifiers.NaiveBayes;
import weka.core.Instance;
import weka.core.Utils;

public class LimAttHoeffdingTreeNBAdaptive
extends LimAttHoeffdingTreeNB {
    private static final long serialVersionUID = 1L;

    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations) {
        return new LearningNodeNBAdaptive(initialClassObservations);
    }

    public static class LearningNodeNBAdaptive
    extends LimAttHoeffdingTreeNB.LearningNodeNB {
        private static final long serialVersionUID = 1L;
        protected double mcCorrectWeight = 0.0;
        protected double nbCorrectWeight = 0.0;

        public LearningNodeNBAdaptive(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            int trueClass = (int)inst.classValue();
            if (this.observedClassDistribution.maxIndex() == trueClass) {
                this.mcCorrectWeight += inst.weight();
            }
            if (Utils.maxIndex((double[])NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers)) == trueClass) {
                this.nbCorrectWeight += inst.weight();
            }
            super.learnFromInstance(inst, ht);
        }

        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            if (this.mcCorrectWeight > this.nbCorrectWeight) {
                return this.observedClassDistribution.getArrayCopy();
            }
            double[] ret = NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
            int i = 0;
            while (i < ret.length) {
                int n = i++;
                ret[n] = ret[n] * this.observedClassDistribution.sumOfValues();
            }
            return ret;
        }
    }
}

