/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import moa.classifiers.AbstractClassifier;
import moa.classifiers.AttributeClassObserver;
import moa.classifiers.HoeffdingTree;
import weka.core.Instance;

public class RandomHoeffdingTree
extends HoeffdingTree {
    private static final long serialVersionUID = 1L;

    public RandomHoeffdingTree() {
        this.removePoorAttsOption = null;
    }

    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations) {
        return new RandomLearningNode(initialClassObservations);
    }

    public boolean isRandomizable() {
        return true;
    }

    public static class RandomLearningNode
    extends HoeffdingTree.ActiveLearningNode {
        private static final long serialVersionUID = 1L;
        protected int[] listAttributes;
        protected int numAttributes;

        public RandomLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            int j;
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            if (this.listAttributes == null) {
                this.numAttributes = (int)Math.floor(Math.sqrt(inst.numAttributes()));
                this.listAttributes = new int[this.numAttributes];
                for (j = 0; j < this.numAttributes; ++j) {
                    boolean isUnique = false;
                    block1: while (!isUnique) {
                        this.listAttributes[j] = ht.classifierRandom.nextInt(inst.numAttributes() - 1);
                        isUnique = true;
                        for (int i = 0; i < j; ++i) {
                            if (this.listAttributes[j] != this.listAttributes[i]) continue;
                            isUnique = false;
                            continue block1;
                        }
                    }
                }
            }
            for (j = 0; j < this.numAttributes - 1; ++j) {
                int i = this.listAttributes[j];
                int instAttIndex = AbstractClassifier.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = (AttributeClassObserver)this.attributeObservers.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? ht.newNominalClassObserver() : ht.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
            }
        }
    }
}

