/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import moa.classifiers.HoeffdingTree;
import moa.gui.GUIUtils;
import moa.gui.OptionEditComponent;
import moa.options.Option;
import moa.options.OptionHandler;
import moa.options.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int FIXED_PANEL_WIDTH = 400;
    public static final int MAX_PANEL_HEIGHT = 300;
    protected Options options;
    protected List<OptionEditComponent> editComponents = new LinkedList<OptionEditComponent>();
    protected JButton helpButton = new JButton("Help");
    protected JButton resetButton = new JButton("Reset to defaults");

    public OptionsConfigurationPanel(String purposeString, Options options) {
        this.options = options;
        this.setLayout(new BorderLayout());
        if (purposeString != null) {
            JTextArea purposeTextArea = new JTextArea(purposeString, 3, 0);
            purposeTextArea.setEditable(false);
            purposeTextArea.setLineWrap(true);
            purposeTextArea.setWrapStyleWord(true);
            purposeTextArea.setEnabled(false);
            purposeTextArea.setBorder(BorderFactory.createTitledBorder("Purpose"));
            purposeTextArea.setBackground(this.getBackground());
            JScrollPane scrollPanePurpose = new JScrollPane(purposeTextArea, 20, 31);
            scrollPanePurpose.setBorder(null);
            this.add((Component)scrollPanePurpose, "North");
        }
        JPanel optionsPanel = OptionsConfigurationPanel.createLabelledOptionComponentListPanel(options.getOptionArray(), this.editComponents);
        JScrollPane scrollPane = new JScrollPane(optionsPanel, 20, 31);
        scrollPane.setBorder(null);
        int optionPanelHeight = (int)optionsPanel.getPreferredSize().getHeight();
        int scrollPaneHeight = (int)scrollPane.getPreferredSize().getHeight();
        scrollPane.setPreferredSize(new Dimension(400, scrollPaneHeight > 300 ? 300 : scrollPaneHeight));
        optionsPanel.setPreferredSize(new Dimension(0, optionPanelHeight));
        this.add((Component)scrollPane, "Center");
        JPanel lowerButtons = new JPanel();
        lowerButtons.setLayout(new FlowLayout());
        lowerButtons.add(this.helpButton);
        lowerButtons.add(this.resetButton);
        this.add((Component)lowerButtons, "South");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OptionsConfigurationPanel.this.showHelpDialog();
            }
        });
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OptionsConfigurationPanel.this.resetToDefaults();
            }
        });
    }

    public static boolean showEditOptionsDialog(Component parent, String title, OptionHandler optionHandler) {
        OptionsConfigurationPanel panel = new OptionsConfigurationPanel(optionHandler.getPurposeString(), optionHandler.getOptions());
        if (JOptionPane.showOptionDialog(parent, panel, title, 2, -1, null, null, null) == 0) {
            panel.applyChanges();
            return true;
        }
        return false;
    }

    public String getHelpText() {
        return this.options.getHelpString();
    }

    public void showHelpDialog() {
        JTextArea helpTextArea = new JTextArea(this.getHelpText(), 20, 80);
        helpTextArea.setFont(new Font("Monospaced", 0, 12));
        helpTextArea.setEditable(false);
        JOptionPane.showMessageDialog(this, new JScrollPane(helpTextArea), "Options Help", 1);
    }

    public void resetToDefaults() {
        for (OptionEditComponent editor : this.editComponents) {
            editor.setEditState(editor.getEditedOption().getDefaultCLIString());
        }
    }

    public void applyChanges() {
        for (OptionEditComponent editor : this.editComponents) {
            try {
                editor.applyState();
            }
            catch (Exception ex) {
                GUIUtils.showExceptionDialog(this, "Problem with option " + editor.getEditedOption().getName(), ex);
            }
        }
    }

    protected static JPanel createLabelledOptionComponentListPanel(Option[] options, List<OptionEditComponent> editComponents) {
        JPanel panel = new JPanel();
        if (options != null && options.length > 0) {
            GridBagLayout gbLayout = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            panel.setLayout(gbLayout);
            for (int i = 0; i < options.length; ++i) {
                JLabel label = new JLabel(options[i].getName());
                label.setToolTipText(options[i].getPurpose());
                gbc.gridx = 0;
                gbc.fill = 0;
                gbc.anchor = 13;
                gbc.weightx = 0.0;
                gbc.insets = new Insets(5, 5, 5, 5);
                gbLayout.setConstraints(label, gbc);
                panel.add(label);
                JComponent editor = options[i].getEditComponent();
                label.setLabelFor(editor);
                if (editComponents != null) {
                    editComponents.add((OptionEditComponent)((Object)editor));
                }
                gbc.gridx = 1;
                gbc.fill = 2;
                gbc.anchor = 10;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(5, 5, 5, 5);
                gbLayout.setConstraints(editor, gbc);
                panel.add(editor);
            }
        } else {
            panel.add(new JLabel("No options."));
        }
        return panel;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        Options options = new HoeffdingTree().getOptions();
        OptionsConfigurationPanel panel = new OptionsConfigurationPanel(null, options);
        panel.setOpaque(true);
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OptionsConfigurationPanel.createAndShowGUI();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

