/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.ClassLister;
import adams.core.io.SpreadSheet;
import adams.core.option.AbstractOptionHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.output.WriterOutputStream;

public abstract class AbstractSpreadSheetWriter
extends AbstractOptionHandler {
    private static final long serialVersionUID = -3547064795252689769L;
    protected String m_MissingValue;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("missing", "missingValue", this.getDefaultMissingValue());
    }

    public abstract String getFormatDescription();

    public abstract String[] getFormatExtensions();

    protected String getDefaultMissingValue() {
        return "";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values.";
    }

    protected abstract boolean getUseOutputStream();

    public boolean write(SpreadSheet content, File file) {
        return this.write(content, file.getAbsolutePath());
    }

    public boolean write(SpreadSheet content, String filename) {
        boolean result = true;
        try {
            if (this.getUseOutputStream()) {
                FileOutputStream output = new FileOutputStream(filename);
                result = this.doWrite(content, output);
                ((OutputStream)output).close();
            } else {
                BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
                result = this.doWrite(content, writer);
                writer.close();
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public boolean write(SpreadSheet content, OutputStream stream) {
        if (this.getUseOutputStream()) {
            return this.doWrite(content, stream);
        }
        return this.doWrite(content, new OutputStreamWriter(stream));
    }

    public boolean write(SpreadSheet content, Writer writer) {
        if (this.getUseOutputStream()) {
            return this.doWrite(content, (OutputStream)new WriterOutputStream(writer));
        }
        return this.doWrite(content, writer);
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        return false;
    }

    protected boolean doWrite(SpreadSheet content, OutputStream out) {
        return false;
    }

    public static String[] getWriters() {
        return ClassLister.getSingleton().getClassnames(AbstractSpreadSheetWriter.class);
    }
}

