/*
 * Decompiled with CFR 0.152.
 */
package adams.data.fit;

import adams.core.ClassLister;
import adams.core.ConsoleObject;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;

public abstract class Function
extends ConsoleObject
implements OptionHandler {
    private static final long serialVersionUID = -1400960650078696595L;
    protected OptionManager m_OptionManager;
    protected boolean m_Debug;

    public Function() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
    }

    public abstract String globalInfo();

    protected void initialize() {
    }

    protected OptionManager newOptionManager() {
        return new OptionManager(this);
    }

    @Override
    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
        this.m_OptionManager.add("D", "debug", false);
    }

    @Override
    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    @Override
    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    @Override
    public void destroy() {
        this.cleanUpOptions();
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
        this.getDebugging().setEnabled(value);
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, function may output additional info to the console.";
    }

    public abstract double calcY(double var1, double[] var3);

    public String toString() {
        return OptionUtils.getCommandLine(this);
    }

    public static String[] getFunctions() {
        return ClassLister.getSingleton().getClassnames(Function.class);
    }

    public static Function forName(String classname, String[] options) {
        Function result;
        try {
            result = (Function)OptionUtils.forName(Function.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }
}

