/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.AbstractOptionalSampleArrayStatistic;
import adams.data.statistics.EqualLengthArrayStatistic;
import adams.data.statistics.StatUtils;

public class ArrayStandardScores<T extends Number>
extends AbstractOptionalSampleArrayStatistic<T>
implements EqualLengthArrayStatistic {
    private static final long serialVersionUID = 3595293227007460735L;
    protected boolean m_UseAlwaysFirstStats;

    @Override
    public String globalInfo() {
        return "Calculates the standard scores (or z scores) of the provided arrays.The arrays must be numeric, of course.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("always-first-stats", "useAlwaysFirstStats", false);
    }

    public void setUseAlwaysFirstStats(boolean value) {
        this.m_UseAlwaysFirstStats = value;
        this.reset();
    }

    public boolean getUseAlwaysFirstStats() {
        return this.m_UseAlwaysFirstStats;
    }

    public String useAlwaysFirstStdevTipText() {
        return "If set to true, then the mean/stdev of the first array are always used to calculate the scores.";
    }

    @Override
    public int getLength() {
        if (this.size() > 0) {
            return ((Number[])this.get(0)).length;
        }
        return -1;
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        String prefix = "z-scores";
        prefix = this.getIsSample() ? prefix + "-sample" : prefix + "-pop.";
        int start = 0;
        if (this.m_UseAlwaysFirstStats) {
            ++start;
        }
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(this.getLength(), this.size() - start);
        for (int i = start; i < this.size(); ++i) {
            if (this.size() > 1) {
                if (this.m_UseAlwaysFirstStats) {
                    result.setHeader(i - start, prefix + " 1-" + (i + 1));
                } else {
                    result.setHeader(i - start, prefix + " " + (i + 1));
                }
            } else {
                result.setHeader(i - start, prefix);
            }
            double[] scores = !this.m_UseAlwaysFirstStats ? StatUtils.standardScores((Number[])this.get(i), this.getIsSample()) : StatUtils.standardScores((Number[])this.get(0), (Number[])this.get(i), this.getIsSample());
            for (int n = 0; n < scores.length; ++n) {
                result.setCell(n, i - start, scores[n]);
            }
        }
        return result;
    }
}

