/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseString;
import adams.flow.core.Token;
import adams.flow.source.AbstractInteractiveSource;
import javax.swing.JOptionPane;

public class EnterValue
extends AbstractInteractiveSource {
    private static final long serialVersionUID = 8200691218381875131L;
    protected String m_Message;
    protected String m_InitialValue;
    protected BaseString[] m_SelectionValues;
    protected Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Pops up a dialog, prompting the user to enter a value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("message", "message", "Please enter a value");
        this.m_OptionManager.add("initial-value", "initialValue", "");
        this.m_OptionManager.add("selection-values", "selectionValues", new BaseString[0]);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("message");
        String result = variable != null ? variable : this.m_Message;
        if (this.m_StopFlowIfCanceled) {
            result = result + " [stops flow if canceled]";
        }
        return result;
    }

    public void setMessage(String value) {
        this.m_Message = value;
        this.reset();
    }

    public String getMessage() {
        return this.m_Message;
    }

    public String messageTipText() {
        return "The message to prompt the user with.";
    }

    public void setInitialValue(String value) {
        this.m_InitialValue = value;
        this.reset();
    }

    public String getInitialValue() {
        return this.m_InitialValue;
    }

    public String initialValueTipText() {
        return "The initial value to prompt the user with.";
    }

    public void setSelectionValues(BaseString[] value) {
        this.m_SelectionValues = value;
        this.reset();
    }

    public BaseString[] getSelectionValues() {
        return this.m_SelectionValues;
    }

    public String selectionValuesTipText() {
        return "The options to let the user choose from.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    public boolean doInteract() {
        String value;
        if (this.m_SelectionValues.length > 0) {
            Object[] options = new String[this.m_SelectionValues.length];
            for (int i = 0; i < options.length; ++i) {
                options[i] = this.m_SelectionValues[i].getValue();
            }
            value = (String)JOptionPane.showInputDialog(null, this.m_Message, this.getName(), 3, null, options, this.m_InitialValue);
        } else {
            value = JOptionPane.showInputDialog(this.m_Message, (Object)this.m_InitialValue);
        }
        if (value != null && value.length() > 0) {
            this.m_OutputToken = new Token(value);
        }
        return value != null && value.length() > 0;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

