/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderDirectory;
import adams.flow.core.Token;
import adams.flow.source.AbstractInteractiveSource;
import adams.gui.chooser.BaseDirectoryChooser;
import java.io.File;

public class SelectDirectory
extends AbstractInteractiveSource {
    private static final long serialVersionUID = -3223325917850709883L;
    protected String m_DirectoryChooserTitle;
    protected PlaceholderDirectory m_InitialDirectory;
    protected boolean m_AbsoluteDirectoryName;
    protected Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Pops up a directory chooser dialog, prompting the user to select a directory. The directory then gets forwarded as string.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dir-chooser-title", "directoryChooserTitle", "");
        this.m_OptionManager.add("initial-dir", "initialDirectory", new PlaceholderDirectory("."));
        this.m_OptionManager.add("absolute", "absoluteDirectoryName", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    @Override
    public String getQuickInfo() {
        String result = "directory: ";
        String variable = this.getOptionManager().getVariableForProperty("initialDirectory");
        result = variable != null ? result + variable : result + this.m_InitialDirectory.toString();
        result = result + " (absolute)";
        if (this.m_StopFlowIfCanceled) {
            result = result + " [stops flow if canceled]";
        }
        return result;
    }

    public void setDirectoryChooserTitle(String value) {
        this.m_DirectoryChooserTitle = value;
        this.reset();
    }

    public String getDirectoryChooserTitle() {
        return this.m_DirectoryChooserTitle;
    }

    public String directoryChooserTitleTipText() {
        return "The title for the directory chooser dialog.";
    }

    public void setInitialDirectory(PlaceholderDirectory value) {
        this.m_InitialDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getInitialDirectory() {
        return this.m_InitialDirectory;
    }

    public String initialDirectoryTipText() {
        return "The initial directory for the directory chooser.";
    }

    public void setAbsoluteDirectoryName(boolean value) {
        this.m_AbsoluteDirectoryName = value;
        this.reset();
    }

    public boolean getAbsoluteDirectoryName() {
        return this.m_AbsoluteDirectoryName;
    }

    public String absoluteDirectoryNameTipText() {
        return "If enabled, the directory name is output in absolute instead of relative form.";
    }

    protected Class getItemClass() {
        return String.class;
    }

    @Override
    public boolean doInteract() {
        boolean result = false;
        BaseDirectoryChooser dirChooser = new BaseDirectoryChooser();
        if (this.m_DirectoryChooserTitle.length() > 0) {
            dirChooser.setDialogTitle(this.m_DirectoryChooserTitle);
        }
        dirChooser.setCurrentDirectory(this.m_InitialDirectory);
        int retVal = dirChooser.showOpenDialog(null);
        if (retVal == 0) {
            result = true;
            File file = dirChooser.getSelectedFile();
            this.m_OutputToken = this.m_AbsoluteDirectoryName ? new Token(file.getAbsolutePath()) : new Token(file.toString());
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

