/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Utils;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.db.SQLStatement;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.DatabaseConnection;

public class ExecSQL
extends AbstractStandalone {
    private static final long serialVersionUID = -2766505525494708760L;
    protected SQLStatement m_SQL;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    public String globalInfo() {
        return "Executes a SQL statement, which does not return a result set, like INSERT, UPDATE, DELETE, CREATE.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sql", "SQL", new SQLStatement(""));
    }

    @Override
    public String getQuickInfo() {
        String result = null;
        String variable = this.getOptionManager().getVariableForProperty("SQL");
        result = variable != null ? variable : Utils.shorten(this.m_SQL.getValue().replaceAll("\\s", " ").replaceAll("[ ]+", " "), 50);
        return result;
    }

    public void setSQL(SQLStatement value) {
        this.m_SQL = value;
        this.reset();
    }

    public SQLStatement getSQL() {
        return this.m_SQL;
    }

    public String SQLTipText() {
        return "The SQL statement to run that generates the IDs.";
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection(this, DatabaseConnection.class, adams.db.DatabaseConnection.getSingleton());
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        String query = this.m_SQL.getValue();
        query = this.getVariables().expand(query);
        try {
            SQL sql = new SQL(this.getDatabaseConnection());
            if (this.isDebugOn()) {
                this.debug("Query: " + query);
            }
            sql.execute(query);
        }
        catch (Exception e) {
            String msg = "Failed to execute query '" + query + "': ";
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
            result = msg + e.toString();
        }
        return result;
    }
}

