/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.parser.GrammarSupplier;
import adams.parser.MathematicalExpression;
import java.util.HashMap;

public class MathExpression
extends AbstractTransformer
implements GrammarSupplier {
    private static final long serialVersionUID = -8477454145267616359L;
    public static final String PLACEHOLDER_INPUT = "X";
    protected String m_Expression;
    protected boolean m_OutputValuePair;

    @Override
    public String globalInfo() {
        return "Evaluates a mathematical expression.\nThe input value can be accessed via 'X'.\nVariables are supported as well, e.g.: pow(X,@{exp}) with '@{exp}' being a variable available at execution time.\n\nThe following grammar is used for the expressions:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return new MathematicalExpression().getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", PLACEHOLDER_INPUT);
        this.m_OptionManager.add("output-value-pair", "outputValuePair", false);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("expression");
        if (variable != null) {
            return variable;
        }
        if (this.m_Expression != null && this.m_Expression.length() > 0) {
            return this.m_Expression;
        }
        return null;
    }

    public void setExpression(String value) {
        this.m_Expression = value;
        this.reset();
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The mathematical expression to evaluate; the input value can be accessed via 'X'.";
    }

    public void setOutputValuePair(boolean value) {
        this.m_OutputValuePair = value;
        this.reset();
    }

    public boolean getOutputValuePair() {
        return this.m_OutputValuePair;
    }

    public String outputValuePairTipText() {
        return "If enabled, a double array with X and Y is output and not just Y.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Integer.class, Double.class};
    }

    @Override
    public Class[] generates() {
        if (this.m_OutputValuePair) {
            return new Class[]{Double[].class};
        }
        return new Class[]{Double.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && (this.m_Expression == null || this.m_Expression.length() == 0)) {
            result = "No expression provided!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        String exp = this.m_Expression;
        try {
            double x = this.m_InputToken.getPayload() instanceof Integer ? (double)((Integer)this.m_InputToken.getPayload()).intValue() : (Double)this.m_InputToken.getPayload();
            exp = this.getVariables().expand(exp);
            HashMap<String, Double> symbols = new HashMap<String, Double>();
            symbols.put(PLACEHOLDER_INPUT, new Double(x));
            double y = MathematicalExpression.evaluate(exp, symbols);
            this.m_OutputToken = this.m_OutputValuePair ? new Token(new Double[]{x, y}) : new Token(new Double(y));
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            this.getSystemErr().println("Error evaluating: " + exp);
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

