/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import com.l2fprod.common.swing.JDirectoryChooser;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class BaseDirectoryChooser
extends JDirectoryChooser {
    private static final long serialVersionUID = -7252242971482953986L;

    public BaseDirectoryChooser() {
        this.initialize();
    }

    public BaseDirectoryChooser(File currentDirectory) {
        super(currentDirectory.getAbsoluteFile());
        this.initialize();
    }

    public BaseDirectoryChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory.getAbsoluteFile(), fsv);
        this.initialize();
    }

    public BaseDirectoryChooser(FileSystemView fsv) {
        super(fsv);
        this.initialize();
    }

    public BaseDirectoryChooser(String currentDirectoryPath) {
        super(new PlaceholderFile(currentDirectoryPath).getAbsolutePath());
        this.initialize();
    }

    public BaseDirectoryChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(new PlaceholderFile(currentDirectoryPath).getAbsolutePath(), fsv);
        this.initialize();
    }

    protected void initialize() {
    }

    public void addChoosableFileFilter(FileFilter filter) {
    }

    public void setSelectedFile(File file) {
        File selFile = null;
        if (file != null) {
            selFile = new File(file.getAbsolutePath());
        }
        super.setSelectedFile(selFile);
    }

    public File getSelectedFile() {
        File result = super.getSelectedFile();
        if (result != null) {
            int pos = result.getPath().lastIndexOf("${");
            result = pos > -1 ? new PlaceholderFile(result.getPath().substring(pos)) : new PlaceholderFile(result);
        }
        return result;
    }

    public void setSelectedFiles(File[] selectedFiles) {
        File[] files = null;
        if (selectedFiles != null) {
            files = new File[selectedFiles.length];
            for (int i = 0; i < selectedFiles.length; ++i) {
                files[i] = new File(selectedFiles[i].getAbsolutePath());
            }
        }
        super.setSelectedFiles(files);
    }

    public File[] getSelectedFiles() {
        File[] result = super.getSelectedFiles();
        for (int i = 0; i < result.length; ++i) {
            int pos = result[i].getPath().indexOf("${");
            result[i] = pos > -1 ? new PlaceholderFile(result[i].getPath().substring(pos)) : new PlaceholderFile(result[i]);
        }
        return result;
    }

    public File getCurrentDirectory() {
        File current = super.getCurrentDirectory();
        if (current == null) {
            return null;
        }
        return new PlaceholderFile(current);
    }

    public void setCurrentDirectory(File dir) {
        if (dir == null) {
            super.setCurrentDirectory(null);
        } else {
            super.setCurrentDirectory(new PlaceholderFile(dir).getAbsoluteFile());
        }
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseDirectoryChooser chooser = new BaseDirectoryChooser();
        chooser.setCurrentDirectory(new PlaceholderFile("${TMP}"));
        if (chooser.showOpenDialog(null) == 0) {
            System.out.println(chooser.getSelectedFile());
        }
    }
}

