/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.option.AbstractOption;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BaseObjectEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected JTextField m_TextValue;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseObject)object).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        BaseObject result;
        try {
            Class<Object> cls = option.getDefaultValue().getClass();
            if (cls.isArray()) {
                cls = cls.getComponentType();
            }
            if (cls == BaseObject.class) {
                System.err.println("Falling back to BaseString class!");
                cls = BaseString.class;
            }
            result = (BaseObject)cls.newInstance();
            result.setValue(str);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return BaseObjectEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        BaseObject result;
        try {
            Class<Object> cls = this.getValue().getClass();
            if (cls.isArray()) {
                cls = cls.getComponentType();
            }
            if (cls == BaseObject.class) {
                System.err.println("Falling back to BaseString class!");
                cls = BaseString.class;
            }
            result = (BaseObject)cls.newInstance();
            result.setValue(str);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + Utils.backQuoteChars(this.getValue().toString()) + "\")";
        return result;
    }

    protected String getStringToPaint() {
        return "" + this.getValue();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getStringToPaint();
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected BaseObject parse(String s) {
        BaseObject result;
        try {
            result = (BaseObject)this.getValue().getClass().newInstance();
            result.setValue(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "Center");
        this.m_TextValue = new JTextField(20);
        this.m_TextValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    BaseObjectEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    BaseObjectEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Value");
        label.setDisplayedMnemonic('V');
        label.setLabelFor(this.m_TextValue);
        panel.add(label);
        panel.add(this.m_TextValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseObjectEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseObjectEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected boolean isValid(String s) {
        return ((BaseObject)this.getValue()).isValid(s);
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((BaseObject)this.getValue()).getValue());
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue(this.parse(s));
        }
        this.closeDialog();
    }

    protected void discardInput() {
        this.closeDialog();
    }

    @Override
    protected void initForDisplay() {
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
        this.m_TextValue.setToolTipText(((BaseObject)this.getValue()).getTipText());
        this.m_TextValue.grabFocus();
    }
}

