/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.gui.goe.AbstractIntegralNumberEditor;
import javax.swing.SpinnerNumberModel;

public class ByteEditor
extends AbstractIntegralNumberEditor {
    public ByteEditor() {
        this.m_CurrentValue = new Byte("0");
    }

    @Override
    public void setValue(Object value) {
        this.m_CurrentValue = new Byte(((Number)value).byteValue());
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.m_CurrentValue;
    }

    @Override
    protected Object parse(String text) throws IllegalArgumentException {
        Byte result;
        try {
            if (text.length() == 0) {
                text = "0";
            }
            result = new Byte(text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    @Override
    protected void updateBounds(SpinnerNumberModel model) {
        if (this.m_LowerBound == null) {
            model.setMinimum(new Byte(-128));
        } else {
            model.setMinimum(Byte.valueOf(this.m_LowerBound.byteValue()));
        }
        if (this.m_UpperBound == null) {
            model.setMaximum(new Byte(127));
        } else {
            model.setMaximum(Byte.valueOf(this.m_UpperBound.byteValue()));
        }
    }
}

