/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe.eventstree;

import adams.gui.core.BaseTreeNode;
import adams.gui.goe.actorpathtree.ActorPathTree;
import adams.gui.goe.eventstree.EventsNode;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EventsTree
extends ActorPathTree<EventsNode> {
    private static final long serialVersionUID = 6343911349519910301L;

    @Override
    protected EventsNode newNodeInstance(String label) {
        return new EventsNode(label);
    }

    public EventsNode findEvent(String name) {
        BaseTreeNode node;
        EventsNode result = null;
        if (name != null && name.length() > 0 && (node = (BaseTreeNode)this.getTreeModel().getRoot()) != null) {
            Enumeration<TreeNode> enm = node.breadthFirstEnumeration();
            while (enm.hasMoreElements()) {
                EventsNode child;
                node = (BaseTreeNode)enm.nextElement();
                if (!(node instanceof EventsNode) || !(child = (EventsNode)node).isEvent() || !child.getLabel().equals(name)) continue;
                result = child;
                break;
            }
        }
        return result;
    }

    public void selectEvent(String name) {
        EventsNode node = this.findEvent(name);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.setSelectionPath(path);
        }
    }
}

