/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.SortableAndSearchableTable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;

public class XYSequenceTable
extends SortableAndSearchableTable {
    private static final long serialVersionUID = 2387563190701705839L;

    public XYSequenceTable() {
        this(null);
    }

    public XYSequenceTable(Model model) {
        if (model != null) {
            this.setModel(model);
        } else {
            this.setModel(this.newModel(null));
        }
        this.setSelectionMode(0);
    }

    @Override
    protected boolean initialUseOptimalColumnWidths() {
        return true;
    }

    @Override
    protected boolean initialSortNewTableModel() {
        return true;
    }

    @Override
    protected Class getTableModelClass() {
        return Model.class;
    }

    protected Model newModel(XYSequence sequence) {
        return new Model(sequence);
    }

    public void setSequence(XYSequence value) {
        this.setUnsortedModel(this.newModel(value));
    }

    public XYSequence getSequence() {
        return ((Model)this.getUnsortedModel()).getSequence();
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return this.newModel(null);
    }

    public static class Model
    extends AbstractBaseTableModel {
        private static final long serialVersionUID = -7495271447997637509L;
        protected XYSequence m_Sequence;
        protected List<XYSequencePoint> m_Points;

        public Model(XYSequence sequence) {
            this.m_Sequence = sequence;
            this.m_Points = sequence != null ? this.m_Sequence.toList() : new ArrayList<XYSequencePoint>();
        }

        public XYSequence getSequence() {
            return this.m_Sequence;
        }

        @Override
        public int getRowCount() {
            return this.m_Points.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "X";
            }
            if (column == 1) {
                return "Y";
            }
            throw new IllegalArgumentException("Wrong column index: " + column);
        }

        protected Object getValueAt(XYSequencePoint point, int column) {
            if (column == 0) {
                return point.getX();
            }
            if (column == 1) {
                return point.getY();
            }
            throw new IllegalArgumentException("Wrong column index: " + column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = null;
            if (this.m_Sequence != null) {
                result = this.getValueAt(this.m_Points.get(row), column);
            }
            return result;
        }

        public XYSequencePoint getPointAt(int row, int column) {
            XYSequencePoint result = null;
            if (this.m_Sequence != null) {
                result = this.m_Points.get(row);
            }
            return result;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return Double.class;
            }
            if (column == 1) {
                return Double.class;
            }
            throw new IllegalArgumentException("Wrong column index: " + column);
        }
    }
}

