/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.menu.AbstractParameterHandlingWekaMenuItemDefinition;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.gui.ConverterFileChooser;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class InstancesPlot
extends AbstractParameterHandlingWekaMenuItemDefinition {
    private static final long serialVersionUID = -771667287275117680L;
    protected ConverterFileChooser m_FileChooser;

    public InstancesPlot(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new ConverterFileChooser(new File(System.getProperty("user.dir")));
    }

    public void launch() {
        AbstractFileLoader loader;
        File file;
        if (this.m_Parameters.length == 0) {
            int retVal = this.m_FileChooser.showOpenDialog((Component)this.getOwner());
            if (retVal != 0) {
                return;
            }
            file = this.m_FileChooser.getSelectedFile();
            loader = this.m_FileChooser.getLoader();
        } else {
            file = new PlaceholderFile(this.m_Parameters[0]).getAbsoluteFile();
            loader = ConverterUtils.getLoaderForFile((File)file);
        }
        VisualizePanel panel = new VisualizePanel();
        this.getSystemErr().println("Loading instances from " + file);
        try {
            loader.setFile(file);
            Instances i = loader.getDataSet();
            i.setClassIndex(i.numAttributes() - 1);
            PlotData2D pd1 = new PlotData2D(i);
            pd1.setPlotName("Master plot");
            panel.setMasterPlot(pd1);
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace((Throwable)e);
            JOptionPane.showMessageDialog((Component)this.getOwner(), "Error loading file '" + file + "':\n" + e.getMessage());
            return;
        }
        ChildFrame frame = this.createChildFrame((Component)panel, 800, 600);
        frame.setTitle(frame.getTitle() + " - " + file);
    }

    public String getTitle() {
        return "Instances plot";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }
}

